import req from '@/request.js'
import {param} from 'jquery'
const portal = window.context.portal
export default {
  // 添加装备系统
  addEqeSys(data, cb) {
    req.post(portal + `/exam/equipment/sys/`, data).then(res => {
      cb(res.data)
    })
  },
  // 装备系统列表
  getEqeSys(data, cb) {
    req.post(portal + `/exam/equipment/sys/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 获取装备系统下拉树
  geteqTree(data, cb) {
    req.post(portal + `/exam/equipment/sys/getTree`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改装备系统
  editEqeSys(data, cb) {
    req.put(portal + `/exam/equipment/sys/`, data).then(res => {
      cb(res.data)
    })
  },
  // id查询装备系统
  detailId(id, cb) {
    req.get(task + `/exam/equipment/sys/` + id).then(rep => {
      cb(rep.data)
    })
  },
  // 删除单个
  deleteOneEqeSys(ids, cb) {
    return new Promise((resolve, reject) => {
      req.remove(portal + '/exam/equipment/sys/' + ids).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //查询人员类别
  getJobPage(data, cb) {
    req.post(portal + `/api/job/v1/jobs/getJobPage`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除
  deleteEqeSys(ids, cb) {
    req.remove(portal + `/exam/equipment/sys/?ids=` + ids).then(rep => {
      cb(rep.data)
    })
  },
  //获取组织
  getOrgPostPage(data, cb) {
    req.post(portal + `/api/org/v1/orgPosts/getOrgPostPage`, data).then(res => {
      cb(res.data)
    })
  },
  //根据专业id查询组织岗位
  findById(ids, cb) {
    req.get(portal + `/exam/equipment/sys/findById/` + ids).then(rep => {
      cb(rep.data)
    })
  },
  //下载模板
  downModel(data, cb) {
    req.get(portal + `/exam/equipment/sys/downModel`).then(rep => {
      cb(rep.data)
    })
  },
  //导入
  importExcel(data, cb) {
    req.post(portal + `/exam/equipment/sys/importExcel`, data).then(res => {
      cb(res.data)
    })
  },
  //导出
  export(data, cb) {
    req.post(portal + `/exam/equipment/sys/export`, data, 'blob').then(res => {
      cb(res.data)
    })
  }
  //   教练员数据
  //   getUsersByRoleCode(cb) {
  //     req.get(portal + `/api/role/v1/role/findByRoleCode/jly`).then(res => {
  //       console.log(res)

  //       cb(res)
  //     })
  //   }
  // 表格分页
}
