import req from '@/request'

const portal = window.context.portal

// 表格分页
export async function tableData(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/equipmentBase/data/query`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/equipmentBase/data/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/equipmentBase/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req
      .put(portal + `/biz/equipmentBase/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req
      .remove(portal + `/biz/equipmentBase/data/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 模板下载
export function downModel() {
  return new Promise((resolve, reject) => {
    req
      .downloadGet(portal + `/biz/equipmentBase/data/downModel`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出
export function exportData(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/equipmentBase/data/export`, data, 'arraybuffer')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 修改计划状态
export function updateStatus(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/equipmentBase/data/updateStatus?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
