import req from '@/request'

const portal = window.context.portal

// 表格分页
export async function tableData(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/trainQuestion/data/query`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/trainQuestion/data/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/trainQuestion/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req
      .put(portal + `/biz/trainQuestion/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req
      .remove(portal + `/biz/trainQuestion/data/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 模板下载
export function downModel() {
  return new Promise((resolve, reject) => {
    req
      .downloadGet(portal + `/biz/trainQuestion/data/downModel`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出
export function exportData(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/trainQuestion/data/export`, data, 'arraybuffer')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
