package com.artfess.workflow.bpmModel.jobhandler;

import com.artfess.base.constants.SystemConstants;
import com.artfess.bpm.persistence.manager.BpmTaskReminderManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * XxlJob开发示例（Bean模式）
 * <p>
 * 开发步骤：
 * 1、在Spring Bean实例中，开发Job方法，方式格式要求为 "public ReturnT<String> execute(String param)"
 * 2、为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 3、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 * <p>
 * 催办任务
 *
 * @author jason 2020-08-24 18:52:51
 */
@Component
public class TaskReminderXxlJob {

    @Resource
    BpmTaskReminderManager bpmTaskReminderManager;

    /**
     * 1、简单任务示例（Bean模式）
     */
    @XxlJob("taskReminderXxlJob")
    public ReturnT<String> taskReminderXxlJob(String param) throws Exception {
        XxlJobLogger.log("XXL-JOB, 开始执行催办任务.");
        String defaultAccount = SystemConstants.SYSTEM_ACCOUNT;
        // 定时任务中没有当前登录用户，所以需要设置到当前用户上下文中
        ContextUtil.setCurrentUserByAccount(defaultAccount);
        bpmTaskReminderManager.executeTaskReminderJob();
        XxlJobLogger.log("XXL-JOB, 成功执行催办任务.");
        return ReturnT.SUCCESS;
    }
}
