package com.artfess.form.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.constants.CacheKeyConst;
import com.artfess.base.constants.SQLConst;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormPrintTemplate;
import com.artfess.form.persistence.dao.FormPrintTemplateDao;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.persistence.manager.FormPrintTemplateManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service("formPrintTemplateManager")
public class FormPrintTemplateManagerImpl extends BaseManagerImpl<FormPrintTemplateDao, FormPrintTemplate> implements FormPrintTemplateManager {
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormMetaManager formMetaManager;

    @Override
    public void saveFormPrintTemplate(FormPrintTemplate formPrintTemplate) {
        QueryWrapper<FormPrintTemplate> q = new QueryWrapper<>();
        q.eq("FORM_KEY_", formPrintTemplate.getFormKey());
        q.eq("PRINT_TYPE_", formPrintTemplate.getPrintType());
        List<FormPrintTemplate> list = baseMapper.getList(q);
//        List<FormPrintTemplate> list = baseMapper.getList(Wrappers.<FormPrintTemplate>lambdaQuery()
//                .eq(FormPrintTemplate::getFormKey, formPrintTemplate.getFormKey())
//                .eq(FormPrintTemplate::getPrintType, formPrintTemplate.getPrintType()));
        if (list.size() > 0) {
            formPrintTemplate.setIsMain("N");
        } else if (!"".equals(formPrintTemplate.getIsMain())) {
            formPrintTemplate.setIsMain("Y");
        }
        super.create(formPrintTemplate);
    }

    @Override
    @Transactional
    public void setDefaultVersion(String formKey, String id, String printType) {
        QueryWrapper queryWrapper = new QueryWrapper<>().eq("FORM_KEY_", formKey);
        List<FormPrintTemplate> formPrintTemplate = baseMapper.selectList(queryWrapper);
        List<FormPrintTemplate> formPrintTemplateY = formPrintTemplate.stream().filter(v -> id.equals(v.getId())).collect(Collectors.toList());
        formPrintTemplateY.get(0).setIsMain("Y");
        List<FormPrintTemplate> formPrintTemplateN = formPrintTemplate.stream().filter(v -> !id.equals(v.getId())).collect(Collectors.toList());
        formPrintTemplateN.forEach(v -> v.setIsMain("N"));
        baseMapper.updateById(formPrintTemplateY.get(0));
        formPrintTemplateN.forEach(v -> baseMapper.updateById(v));
		/*FormPrintTemplate template=new FormPrintTemplate();
		template.setIsMain("N");
        baseMapper.update(template,(Wrappers.<FormPrintTemplate>lambdaQuery()
                .eq(FormPrintTemplate::getFormKey, formKey)
                .eq(FormPrintTemplate::getPrintType, printType)));
        template.setIsMain("Y");
        baseMapper.update(template ,(Wrappers.<FormPrintTemplate>lambdaQuery()
                .eq(FormPrintTemplate::getFormKey, formKey)
                .eq(FormPrintTemplate::getId, id)));*/
    }

    @Override
    public FormPrintTemplate getMainFormPrintTemplate(String formKey) {
        FormPrintTemplate formPrintTemplate = baseMapper.selectOne((Wrappers.<FormPrintTemplate>lambdaQuery()
                .eq(FormPrintTemplate::getFormKey, formKey)
                .eq(FormPrintTemplate::getIsMain, "Y")
                .eq(FormPrintTemplate::getPrintType, "word")));
        return formPrintTemplate;
    }

    @Override
    public List<FormPrintTemplate> getPrintTemplates(String formKey, String printType) {
        List<FormPrintTemplate> list = baseMapper.getList(Wrappers.<FormPrintTemplate>lambdaQuery()
                .eq(FormPrintTemplate::getFormKey, formKey)
                .eq(FormPrintTemplate::getPrintType, printType));
        return list;
    }

    /**
     * 通过formKey删除缓存中的bpmForm
     *
     * @param formKey
     */
    @CacheEvict(value = CacheKeyConst.EIP_FORM_BPM_FORM, key = "#formKey")
    protected void removeFromCache(String formKey) {
    }

    @Override
    public void removeByIds(String... ids) {
        FormPrintTemplateManagerImpl bean = AppUtil.getBean(getClass());
        for (String id : ids) {
            FormPrintTemplate formPrintTemplate = this.get(id);
            if ("form".equals(formPrintTemplate.getPrintType())) {
                //删除表单
                String formId = formPrintTemplate.getFormId();
                if (StringUtil.isNotEmpty(formId)) {
                    Form bpmForm = bpmFormManager.get(formId);
                    if (BeanUtils.isNotEmpty(bpmForm)) {
                        String formKey = bpmForm.getFormKey();
                        bpmFormManager.remove(bpmForm.getId());
                        String fromDefId = bpmForm.getDefId();
                        formMetaManager.remove(fromDefId);
                        // 删除表单和元数据的时候。一并删除元数据和业务对象的关联关系
                        formMetaManager.deleteBpmFormBo(fromDefId);
                        bean.removeFromCache(formKey);
                    }
                }
            }
            this.remove(id);
        }
    }

    @Override
    public IPage<FormPrintTemplate> getPrintList(QueryFilter<FormPrintTemplate> queryFilter) {
        String dbType = SQLUtil.getDbType();
        IPage<FormPrintTemplate> printList = null;
        if (dbType.equals(SQLConst.DB_POSTGRESQL)) {
            printList = baseMapper.getPrintListPGSQL(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        } else if (dbType.equals(SQLConst.DB_ORACLE) || dbType.equals(SQLConst.DB_DM)) {
            printList = baseMapper.getPrintListOracle(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        } else {
            printList = baseMapper.getPrintList(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        }
        return printList;
    }

    @Override
    public FormPrintTemplate getMailPrintTemplates(String formKey, String printType) {
        FormPrintTemplate formPrintTemplate = baseMapper.selectOne((Wrappers.<FormPrintTemplate>lambdaQuery()
                .eq(FormPrintTemplate::getIsMain, "Y")
                .eq(FormPrintTemplate::getFormKey, formKey)
                .eq(FormPrintTemplate::getPrintType, printType)));
        return formPrintTemplate;
    }
}
