package com.artfess.form.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.bo.model.BoData;
import com.artfess.form.model.FormBusSet;
import com.fasterxml.jackson.databind.JsonNode;

import java.io.IOException;
import java.util.Map;

/**
 * 表单数据处理器
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2020年4月14日
 */
public interface FormBusManager extends BaseManager<FormBusSet> {
    /**
     * 通过 boKey，id获取bo数据
     *
     * @param boKey
     * @param id
     * @return
     */
    BoData getBoData(String boKey, String id) throws IOException;

    /**
     * 通过formKey json 保存bo数据
     *
     * @param formKey
     * @param json
     * @throws IOException
     */
    void saveData(String formKey, String json) throws IOException;

    /**
     * 通过formKey 删除业务数据
     *
     * @param aryIds
     * @param formKey
     */
    void removeByIds(String[] aryIds, String formKey);

    /**
     * 通过 formKey 获取业务数据
     *
     * @param formKey
     * @param param
     * @return
     * @throws IOException
     */
    JsonNode getList(String formKey, Map<String, Object> param) throws IOException;
}
