package com.artfess.form.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.form.model.FormImportCheckJar;
import com.artfess.form.persistence.manager.FormImportCheckJarManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <pre>
 * 描述：form_import_check_jar 控制器类
 * 构建组：x7
 * 作者:heyf
 * 邮箱:heyf@jee-soft.cn
 * 日期:2020-07-13 15:35:03
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value = "/form/formImportCheckJar/v1")
@Api(tags = "formImportCheckJarController")
public class FormImportCheckJarController extends BaseController<FormImportCheckJarManager, FormImportCheckJar> {
    @Resource
    FormImportCheckJarManager formImportCheckJarManager;

    /**
     * form_import_check_jar列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/listJson")
    @ApiOperation(value = "form_import_check_jar数据列表", httpMethod = "POST", notes = "获取form_import_check_jar列表")
    public PageList<FormImportCheckJar> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter queryFilter) throws Exception {
        return formImportCheckJarManager.query(queryFilter);
    }

    /**
     * form_import_check_jar明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/getJson")
    @ApiOperation(value = "form_import_check_jar数据详情", httpMethod = "GET", notes = "form_import_check_jar数据详情")
    public FormImportCheckJar get(@ApiParam(name = "id", value = "业务对象主键", required = true) @RequestParam String id) throws Exception {
        return formImportCheckJarManager.get(id);
    }

    /**
     * 新增form_import_check_jar
     *
     * @param formImportCheckJar
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "save")
    @ApiOperation(value = "新增,更新form_import_check_jar数据", httpMethod = "POST", notes = "新增,更新form_import_check_jar数据")
    public CommonResult<String> save(@ApiParam(name = "formImportCheckJar", value = "form_import_check_jar业务对象", required = true) @RequestBody FormImportCheckJar formImportCheckJar) throws Exception {
        String msg = "添加form_import_check_jar成功";
        if (StringUtil.isEmpty(formImportCheckJar.getId())) {
            formImportCheckJarManager.create(formImportCheckJar);
        } else {
            formImportCheckJarManager.update(formImportCheckJar);
            msg = "更新form_import_check_jar成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 批量删除form_import_check_jar记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove")
    @ApiOperation(value = "批量删除form_import_check_jar记录", httpMethod = "DELETE", notes = "批量删除form_import_check_jar记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        formImportCheckJarManager.removeByIds(ids);
        return new CommonResult<String>(true, "批量删除成功");
    }
}
