package com.artfess.form.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.form.manager.FormCodegenLogManager;
import com.artfess.form.model.FormCodegenLog;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 代码生成日志 前端控制器
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @since 2020-05-09
 */
@RestController
@RequestMapping("/formCodegenLog/v1/")
public class FormCodegenLogController extends BaseController<FormCodegenLogManager, FormCodegenLog> {
    @Resource
    UCFeignService ucFeignService;

    @GetMapping("/{id}")
    @ApiOperation("根据id查询实体")
    @Override
    public FormCodegenLog getById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        FormCodegenLog formCodegenLog = baseService.getById(id);
        if (BeanUtils.isNotEmpty(formCodegenLog)) {
            CommonResult<JsonNode> user = ucFeignService.getUserById(formCodegenLog.getCreateBy());
            if (user != null && user.getState()) {
                JsonNode value = user.getValue();
                if (value != null && value.isObject()) {
                    String fullname = JsonUtil.getString((ObjectNode) value, "fullname");
                    formCodegenLog.setCreateBy(fullname);
                }
            }
        }
        return formCodegenLog;
    }
}
