package com.artfess.base.constants;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * @author min.wu
 * @date 2024-4-08
 */
@NoArgsConstructor
@Getter
@AllArgsConstructor
public enum CodePrefix {

    PAPER_TASK_KEY("bmp:exam:paper:task", "task", "考试任务"),

    STUDY_TASK_KEY("bmp:study:tasks", "study", "学习任务"),

    STUDY_TASK_FILE_KEY("bmp:study:task:file", "task", "学习资料文件"),

    MULTIPART_UPLOADID_KEY("bmp:multipart:uploadId", "upload", "分片上传"),

    MULTIPART_UPLOADID_CHUNK_KEY("bmp:multipart:uploadId:CHUNK", "uploadChunk", "分片上传CHUNK"),

    MULTIPART_UPLOADID_CHUNKNUM_KEY("bmp:multipart:uploadId:CHUNKNUM", "uploadChunkNum", "分片上传CHUNK数量"),
    ;



    private String key;
    private String prefix;
    private String desc;
}
