package com.artfess.query.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.string.StringPool;
import com.artfess.base.util.time.DateUtil;
import com.artfess.query.dao.BizQueryBrowseHistoryDao;
import com.artfess.query.manager.BizQueryBrowseHistoryManager;
import com.artfess.query.model.BizQueryBrowseHistory;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * 个人浏览历史记录日志表（BIZ_QUERY_BROWSE_HISTORY） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Service
public class BizQueryBrowseHistoryManagerImpl extends BaseManagerImpl<BizQueryBrowseHistoryDao, BizQueryBrowseHistory> implements BizQueryBrowseHistoryManager {

    public boolean saveQueryBrowseHistory(BizQueryBrowseHistory bizQueryBrowseHistory){
        IUser user= ContextUtil.getCurrentUser();
        //查询当天是否有浏览记录
        QueryWrapper<BizQueryBrowseHistory> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("USER_ID_",user.getUserId());
        queryWrapper.eq("SEARCH_CONTENT_",bizQueryBrowseHistory.getSearchContent());
        queryWrapper.eq("date_format(SEARCH_TIME_,'%Y-%m-%d')", DateUtil.getCurrentTime(StringPool.DATE_FORMAT_DATE));
        queryWrapper.last(" limit 1");
        BizQueryBrowseHistory temp=this.getOne(queryWrapper);
        if(temp!=null){
            //更新时间
            temp.setSearchTime(LocalDateTime.now());
            return this.updateById(temp);
        }else {
            return this.save(bizQueryBrowseHistory);
        }
    }
}
