package com.artfess.query.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.query.manager.BizQueryTagHistoryManager;
import com.artfess.query.model.BizQueryTagHistory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 搜索记录历史日志表（BIZ_QUERY_TAG_HISTORY） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Api(tags = "企查查--搜索记录历史日志表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_QUERY})
@RestController
@RequestMapping("/query/tagHistory/v1/")
public class BizQueryTagHistoryController extends BaseController<BizQueryTagHistoryManager, BizQueryTagHistory> {

    @PostMapping("/deleteUserAll")
    @ApiOperation("删除用户所有的历史记录")
    public CommonResult<String> deleteUserAll(@ApiParam(name = "userId", value = "登录用户ID") @RequestParam String userId) {
        boolean result = baseService.deleteUserAll(userId);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }
}
