package com.artfess.dataShare.scheduler.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 定时任务  --- Java作业 配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2025-08-05
 */
@ApiModel(value="BizSchedulerJavaTask对象", description="定时任务  --- Java作业 配置表")
@TableName("BIZ_SCHEDULER_JAVA_TASK")
public class BizSchedulerJavaTask extends BaseModel<BizSchedulerJavaTask> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "调度作业ID")
    @TableField("JOB_ID_")
    private String jobId;

    @ApiModelProperty(value = "调度作业名称")
    @TableField("JOB_NAME_")
    private String jobName;

    @ApiModelProperty(value = "执行类型（local：项目内方法，jar：项目外jar）")
    @TableField("JAR_TYPE_")
    private String jarType;

    @ApiModelProperty(value = "jar文件名称")
    @TableField("JAR_NAME_")
    private String jarName;

    @ApiModelProperty(value = "jar文件路径")
    @TableField("JAR_PATH_")
    private String jarPath;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJarType() {
        return jarType;
    }

    public void setJarType(String jarType) {
        this.jarType = jarType;
    }

    public String getJarName() {
        return jarName;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public String getJarPath() {
        return jarPath;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    @Override
    public String toString() {
        return "BizSchedulerJavaTask{" +
                "id='" + id + '\'' +
                ", jobId='" + jobId + '\'' +
                ", jobName='" + jobName + '\'' +
                ", jarType='" + jarType + '\'' +
                ", jarName='" + jarName + '\'' +
                ", jarPath='" + jarPath + '\'' +
                '}';
    }
}
