package com.artfess.dataShare.role.manager;

import com.artfess.dataShare.role.model.BizRoleCatalogs;
import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.role.vo.CatalogsVo;

import java.util.List;

/**
 * 角色数据目录授权表（角色关联人员的目录分类） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-12-25
 */
public interface BizRoleCatalogsManager extends BaseManager<BizRoleCatalogs> {

    /**
     * 查询登录人有权限的数据明细层目录ID
     * @return
     */
    List<CatalogsVo> queryDwCatalogsId(String dataType);

    /**
     * 根据角色Id查询授权的目录
     * @return
     */
    List<CatalogsVo> queryDwCatalogByRoleId(String dataType);
}
