package com.artfess.dataShare.dataShare.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 数据资源--文件共享信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-29
 */
@ApiModel(value="BizShareFiles对象", description="数据资源--文件共享信息")
@TableName("BIZ_SHARE_FILES")
@Data
public class BizShareFiles extends AutoFillModel<BizShareFiles> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据源别名")
    @TableField("DB_ALIAS_")
    private String dbAlias;

    @ApiModelProperty(value = "数据源ID")
    @TableField(exist = false)
    private String databaseId;

    @ApiModelProperty(value = "共享数据资源表ID")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "生成文件的SQL查询语句")
    @TableField("FILE_SQL_")
    private String fileSql;

    @ApiModelProperty(value = "共享资源数据文件名称")
    @TableField("FILE_NAME_")
    private String fileName;

    @ApiModelProperty(value = "共享资源数据文件共享描述")
    @TableField("FILE_CONTENT_")
    private String fileContent;

    @ApiModelProperty(value = "共享数据文件类型（xlscsv）")
    @TableField("FILE_TYPE_")
    private String fileType;

    @ApiModelProperty(value = "共享数据文件大小（单位：kb）")
    @TableField("FILE_SIZE_")
    private String fileSize;

    @ApiModelProperty(value = "共享数据文件下载地址URL")
    @TableField("FILE_PATH_")
    private String filePath;

    @ApiModelProperty(value = "文件是否创建生成（0：否 1：是）")
    @TableField("IS_CREATE_")
    private String isCreate;
}
