package com.artfess.dataShare.dataShare.manager.impl;

import cn.hutool.core.date.DateTime;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTable;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.dataShare.dataShare.dto.TableAuthDto;
import com.artfess.dataShare.dataShare.manager.BizShareApiManager;
import com.artfess.dataShare.dataShare.manager.BizShareFilesManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableFieldManager;
import com.artfess.dataShare.dataShare.model.*;
import com.artfess.dataShare.dataShare.dao.BizShareTableDao;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.dataShare.factory.TableOperatorFactory;
import com.artfess.dataShare.util.Constants;
import com.artfess.dataShare.util.TableFieldVo;
import com.artfess.dataShare.util.TableVo;
import com.artfess.file.config.HwObsSetting;
import com.artfess.file.util.HuaweiyunOssUtil;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.artfess.table.operator.impl.BaseTableOperator;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 数据共享管理--共享资源表管理 （元数据信息+TABLE信息） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-22
 */
@Service
public class BizShareTableManagerImpl extends BaseManagerImpl<BizShareTableDao, BizShareTable> implements BizShareTableManager {

    @Resource
    private DatabaseContext databaseContext;

    @Resource
    private JdbcTemplate jdbcTemplate;

    @Resource
    private BizShareTableFieldManager fieldManager;

    @Resource
    private BizShareApiManager apiManager;

    @Resource
    private BizShareFilesManager filesManager;

    @Resource
    private SysDataSourceManager dataSourceManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean deploy(String id) {
        BizShareTable bizShareTable = baseMapper.selectById(id);
        if ("1".equals(bizShareTable.getIsCreateTable())){

        }
        List<BizShareTableField> fields = fieldManager.list(new LambdaQueryWrapper<BizShareTableField>()
                .eq(BizShareTableField::getIsDele, "0")
                .eq(BizShareTableField::getTableId, id));
        //排序
        fields = fields.stream()
                .sorted(Comparator.comparing(BizShareTableField::getSn))
                .collect(Collectors.toList());
        String dbAlias = bizShareTable.getDbAlias();
        try(DatabaseSwitchResult databaseSwitchResult = databaseContext.setDataSource(dbAlias)){
            String dbType = databaseSwitchResult.getDbType();
            TableVo tableVo = new TableVo();
            tableVo.setTableName(bizShareTable.getTableCode());
            tableVo.setComment(bizShareTable.getTableDesc());
            for (BizShareTableField field : fields) {
                String dataType = field.getDataType();
                Integer attrLength = field.getAttrLength();
                Integer decimalLen = field.getDecimalLen();
                String defaultValue = field.getDefaultValue();
                String desc = field.getDesc();

                TableFieldVo fieldVo = new TableFieldVo();
                fieldVo.setFieldName(field.getFieldCode());
                fieldVo.setComment(desc);
                fieldVo.setIsPk("1".equals(field.getIsPk()) ? true : false);
                fieldVo.setColumnType(dataType);
                fieldVo.setFcolumnType(dataType);
                fieldVo.setCharLen(attrLength);
                fieldVo.setIntLen(attrLength);
                fieldVo.setDecimalLen(decimalLen);
                fieldVo.setDefaultValue(defaultValue);
                fieldVo.setTableName(bizShareTable.getTableCode());
                tableVo.addColumn(fieldVo);
            }
            BaseTableOperator tableOperator = TableOperatorFactory.getTableOperator(dbType);
            tableOperator.setJdbcTemplate(jdbcTemplate);
            tableOperator.createTable(tableVo);
        }catch (Exception e){
            throw new ApplicationException();
        }
        bizShareTable.setDeployedStatus("1");
        bizShareTable.setIsCreateTable("1");
        bizShareTable.setDeployedTime(LocalDateTime.now());
        bizShareTable.setDeployedUsername(ContextUtil.getCurrentUserName());
        int fieldTotal = fieldManager.count(new LambdaQueryWrapper<BizShareTableField>()
                .eq(BizShareTableField::getIsDele, "0")
                .eq(BizShareTableField::getTableId, bizShareTable.getId()));
        bizShareTable.setFieldTotal(fieldTotal);
        baseMapper.updateById(bizShareTable);
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveInfo(BizShareTable table) {
        if (!checkName(table)){
            throw new ApplicationException("改目录下已创建【" + table.getName() + "】资源！");
        }
        table.setIsCreateTable("0");
        table.setDeployedStatus("0");
        table.setIsDele("0");
        if (StringUtil.isEmpty(table.getIsDatabase())){
            table.setIsDatabase("0");
        }
        if (StringUtil.isEmpty(table.getIsApi())){
            table.setIsApi("0");
        }
        if (StringUtil.isEmpty(table.getIsFile())){
            table.setIsFile("0");
        }
        table.setTableNameCh(table.getName());
        table.setTableCode("SHARE_" + table.getTableNameEn());
        return save(table);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeTable(String id) throws Exception {
        List<BizShareTableField> fields = fieldManager.list(new LambdaQueryWrapper<BizShareTableField>()
                .eq(BizShareTableField::getIsDele, "0")
                .eq(BizShareTableField::getTableId, id));
        List<String> fieldIds = fields.stream().map(entity -> entity.getId()).collect(Collectors.toList());
        boolean result = fieldManager.removeByIds(fieldIds);
        BizShareTable table = get(id);
        boolean exists = checkPhysicsTableExists(table.getId(), table.getTableNameEn());
        if (exists){
            String dropSql="drop table " + table.getTableCode();
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(table.getDbAlias());
            template.execute(dropSql);
        }
        return baseMapper.deleteById(id) > 0;
    }

    @Override
    public String queryTableSql(String id) {
        BizShareTable table = get(id);
        List<BizShareTableField> fieldList = fieldManager.queryFieldByTable(id);
        TableVo tableVo = new TableVo();
        tableVo.setTableName(table.getTableCode());
        tableVo.setComment(table.getTableDesc());
        for (BizShareTableField field : fieldList) {
            String dataType = field.getDataType();
            Integer attrLength = field.getAttrLength();
            Integer decimalLen = field.getDecimalLen();
            String defaultValue = field.getDefaultValue();
            String desc = field.getDesc();

            TableFieldVo fieldVo = new TableFieldVo();
            fieldVo.setFieldName(field.getFieldCode());
            fieldVo.setComment(desc);
            fieldVo.setIsPk("1".equals(field.getIsPk()) ? true : false);
            fieldVo.setColumnType(dataType);
            fieldVo.setFcolumnType(dataType);
            fieldVo.setCharLen(attrLength);
            fieldVo.setIntLen(attrLength);
            fieldVo.setDecimalLen(decimalLen);
            fieldVo.setDefaultValue(defaultValue);
            fieldVo.setTableName(table.getTableCode());
            tableVo.addColumn(fieldVo);
        }
        String tableSql = "";
        String dbAlias = table.getDbAlias();
        try(DatabaseSwitchResult databaseSwitchResult = databaseContext.setDataSource(dbAlias);){
            String dbType = databaseSwitchResult.getDbType();
            BaseTableOperator tableOperator = TableOperatorFactory.getTableOperator(dbType);
            tableSql = tableOperator.createTableSql(tableVo);
        }catch (Exception e){
            throw new ApplicationException();
        }
        return tableSql;
    }

    @Override
    public boolean checkTableExists(String tableId, String dbAlias, String tableNameEn) throws Exception {
        BizShareTable table = get(tableId);
            tableNameEn = "SHARE_" + tableNameEn;
        //查询表库是否存在
        if(checkTable(tableId,tableNameEn)){
            return true;
        }
        //查询物理表是否存在
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(dbAlias);
        String sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'";
        return template.queryForObject(sql, Integer.class) > 0 ? true : false;
    }

    @Override
    public boolean checkPhysicsTableExists(String tableId, String tableNameEn) throws Exception {
        BizShareTable table = get(tableId);
        //查询物理表是否存在
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(table.getDbAlias());
        String sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'";
        return template.queryForObject(sql, Integer.class) > 0 ? true : false;
    }

    @Override
    public void deployHaveTable(String tableId) {
        BizShareTable table = this.get(tableId);
        if("1".equals(table.getDeployedStatus())){
            throw new ApplicationException("表已经发布，不能从重复，如果有问题请联系管理员");
        }
        table.setIsCreateTable("1");
        table.setDeployedStatus("1");
        table.setDeployedTime(LocalDateTime.now());
        this.update(table);
    }

    @Override
    public void deployDotHaveTable(String tableId, String tableSql) throws Exception {
        BizShareTable table = this.get(tableId);
        List<BizShareTableField> fields = fieldManager.queryFieldByTable(tableId);
        if("1".equals(table.getDeployedStatus())){
            throw new ApplicationException("表已经发布，不能从重复，如果有问题请联系管理员");
        }
        if(fields.size()==0){
            throw new ApplicationException("表内没有字段不能发布");
        }
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(table.getDbAlias());
        table.setIsCreateTable("1");
        table.setDeployedStatus("1");
        table.setDeployedTime(LocalDateTime.now());
        table.setCreateTableSql(tableSql);
        template.execute(table.getCreateTableSql());
        this.update(table);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeBatch(List<String> ids) throws Exception {
        for (String id : ids) {
            removeTable(id);
        }
        return true;
    }

    @Override
    public BizShareTable queryTableField(String id) {
        BizShareTable table = get(id);
        List<BizShareTableField> fields = fieldManager.queryFieldByTable(table.getId());
        table.setTableFieldList(fields);
        return table;
    }

    @Override
    public PageList<BizShareTable> queryPage(QueryFilter<BizShareTable> queryFilter) {
        PageList<BizShareTable> pageList = query(queryFilter);
        List<BizShareTable> tableList = pageList.getRows();
        for (BizShareTable table : tableList) {
            String tableId = table.getId();
            List<BizShareApi> apis = apiManager.queryByTableId(tableId);
            List<BizShareFiles> files = filesManager.queryByTableId(tableId);
            table.setApiList(apis);
            table.setFilesList(files);
        }
        return pageList;
    }

    @Override
    public BizShareTable queryTableInfo(String id) {
        BizShareTable table = get(id);
        SysDataSource dataSource = dataSourceManager.getOne(new LambdaQueryWrapper<SysDataSource>()
                .eq(SysDataSource::getAlias, table.getDbAlias()));
        if (BeanUtils.isNotEmpty(dataSource)){
            table.setDatabaseId(dataSource.getId());
        }
        return table;
    }

    @Override
    public PageList<BizShareTable> queryAuthPage(QueryFilter<BizShareTable> queryFilter, String consumerId) {
        IPage<BizShareTable> iPage = baseMapper.queryAuthPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()),consumerId);
        return new PageList<>(iPage);
    }

    private boolean checkTable(String tableId,String tableNameEn) {
        LambdaQueryWrapper<BizShareTable> queryWrapper = new LambdaQueryWrapper<BizShareTable>()
                .eq(BizShareTable::getIsDele, "0")
                .eq(BizShareTable::getTableCode, tableNameEn);
        if (StringUtil.isNotEmpty(tableId)){
            queryWrapper.ne(BizShareTable::getId,tableId);
        }
        int count = count(queryWrapper);
        return count > 0 ? true : false;
    }

    private boolean checkName(BizShareTable table){
        String id = table.getId();
        String name = table.getName();
        String catalogId = table.getCatalogId();
        LambdaQueryWrapper<BizShareTable> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BizShareTable::getCatalogId,catalogId);
        queryWrapper.eq(BizShareTable::getName,name);
        if (StringUtil.isNotEmpty(id)){
            queryWrapper.ne(BizShareTable::getId,id);
        }
        Integer count = this.baseMapper.selectCount(queryWrapper);
        if (count > 0){
            return false;
        }
        return true;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateCatalog(String[] ids, String catalogId) {
        int count = baseMapper.updateCatalog(ids,catalogId);
        return count > 0 ? true : false;
    }
}
