package com.artfess.dataShare.dataShare.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataCollect.model.BizClusterTableField;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.dataShare.dataResource.ods.vo.BizOdsFieldVo;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.dataShare.dataShare.model.BizShareTableField;
import com.artfess.dataShare.dataShare.dao.BizShareTableFieldDao;
import com.artfess.dataShare.dataShare.manager.BizShareTableFieldManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.dataShare.dataShare.vo.ShareTableFieldVo;
import com.artfess.dataShare.factory.TableOperatorFactory;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.dataShare.util.TableFieldVo;
import com.artfess.dataShare.util.TableVo;
import com.artfess.poi.util.ExcelTool;
import com.artfess.table.factory.TableOperatorFactoryBean;
import com.artfess.table.operator.impl.BaseTableOperator;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.fop.util.ListUtil;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;
import java.sql.SQLException;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 数据共享管理--共享资源表字段信息（字段） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-22
 */
@Service
public class BizShareTableFieldManagerImpl extends BaseManagerImpl<BizShareTableFieldDao, BizShareTableField> implements BizShareTableFieldManager {

    @Resource
    private DatabaseContext databaseContext;

    @Resource
    private BizShareTableManager tableManager;

    @Resource
    private BizShareTableFieldManager fieldManager;

//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public boolean saveInfoBatch(BizShareTable table) {
//        List<BizShareTableField> oldFields = baseMapper.selectList(new LambdaQueryWrapper<BizShareTableField>()
//                .eq(BizShareTableField::getIsDele, "0")
//                .eq(BizShareTableField::getTableId, table.getId()));
//        if (oldFields != null && oldFields.size() > 0){
//            List<String> oldIds = oldFields.stream().map(entity -> entity.getId()).collect(Collectors.toList());
//            //删除旧数据
//            this.baseMapper.deleteBatchIds(oldIds);
//        }
//
//        BizShareTable oldTable = tableManager.get(table.getId());
//        String alias = oldTable.getDbAlias();
//        String dbType = "";
//        try(DatabaseSwitchResult databaseSwitchResult = databaseContext.setDataSource(alias);){
//            dbType = databaseSwitchResult.getDbType();
//        }catch (Exception e){
//            throw new ApplicationException();
//        }
//        //数据库类型
//        String finalDbType = dbType;
//
//        List<BizShareTableField> tableFieldList = table.getTableFieldList();
//        //排序
//        tableFieldList = tableFieldList.stream()
//                .sorted(Comparator.comparing(BizShareTableField::getSn))
//                .collect(Collectors.toList());
//        Set<String> fieldSet = new HashSet<>();
//
//        String tableSql = "CREATE TABLE IF NOT EXISTS " + oldTable.getTableCode() + "(\n";
//
//        int keyIndex = -1;
//        for (int i = 0; i < tableFieldList.size(); i++) {
//            BizShareTableField field = tableFieldList.get(i);
//            if (fieldSet.contains(field.getCode())){
//                throw new ApplicationException("同一张表下不能创建相同的字段！");
//            }else {
//                fieldSet.add(field.getCode());
//            }
//            field.setIsDele("0");
//            if (StringUtil.isEmpty(field.getIsPk())){
//                field.setIsPk("0");
//            }
//            field.setTableId(oldTable.getId());
//            field.setResourceName(oldTable.getName());
//            field.setResourceCode(oldTable.getCode());
//            field.setFieldCode("F_" + field.getCode());
//            field.setIsCreate("0");
//            String dataType = field.getDataType();
//            Integer attrLength = field.getAttrLength();
//            Integer decimalLen = field.getDecimalLen();
//            String defaultValue = field.getDefaultValue();
//            String desc = field.getDesc();
//            String flSql = "";
//            //mysql建表语句
//            if ("mysql".equalsIgnoreCase(finalDbType)){
//                flSql = flSql + "`" + field.getFieldCode() + "`";
//                if (dataType.equalsIgnoreCase("string")){
//                    flSql = flSql + " varchar(" + attrLength + ")";
//                    if (StringUtil.isNotEmpty(defaultValue)){
//                        flSql = flSql + " DEFAULT " + "'" +defaultValue+ "'";
//                    }else {
//                        if ("0".equals(field.getIsPk())){
//                            flSql = flSql + " DEFAULT NULL";
//                        }
//                    }
//                } else if (dataType.equalsIgnoreCase("number")) {
//                    flSql += "DECIMAL(" + (attrLength + decimalLen) + "," + decimalLen + ")";
//                } else if (dataType.equalsIgnoreCase("datetime")) {
//                    flSql += " DATETIME";
//                }
//                flSql = flSql + " COMMENT " + "\"" + desc + "\"";
//                if ("1".equals(field.getIsPk())){
//                    keyIndex = i;
//                }
//                if (i == tableFieldList.size() - 1){
//                    tableSql = tableSql + flSql + "\n";
//                }else {
//                    tableSql = tableSql + flSql + ",\n";
//                }
//            }
//            field.setFlSql(flSql);
//        }
//        tableSql = tableSql + "," + "PRIMARY KEY (`" + tableFieldList.get(keyIndex).getFieldCode() + "`)\n";
//        tableSql += ")";
//        oldTable.setCreateTableSql(tableSql);
//        saveBatch(tableFieldList);
//        //更新建表语句
//        return tableManager.updateById(oldTable);
//    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveInfoBatch(BizShareTable table) throws SQLException {
        List<BizShareTableField> oldFields = baseMapper.selectList(new LambdaQueryWrapper<BizShareTableField>()
                .eq(BizShareTableField::getIsDele, "0")
                .eq(BizShareTableField::getTableId, table.getId()));
//        if (oldFields != null && oldFields.size() > 0){
//            List<String> oldIds = oldFields.stream().map(entity -> entity.getId()).collect(Collectors.toList());
//            //删除旧数据
//            this.baseMapper.deleteBatchIds(oldIds);
//
//        }
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0){
            //只删除业务字段
            fieldManager.removeByIds(oldFields.stream().filter(p->"2".equals(p.getFieldType())).map(entity -> entity.getId()).collect(Collectors.toList()));
        }

        BizShareTable oldTable = tableManager.get(table.getId());

        List<BizShareTableField> tableFieldList = table.getTableFieldList();
        //表里面没有字段的时候才加默认的管理字段
        if(oldFields.size()==0){
            addManageField(tableFieldList);
        }
        //排序
//        tableFieldList = tableFieldList.stream()
//                .sorted(Comparator.comparing(BizShareTableField::getSn))
//                .collect(Collectors.toList());
        Set<String> fieldSet = new HashSet<>();

        tableFieldList.stream().map(field -> {
            if (fieldSet.contains(field.getCode())){
                throw new ApplicationException("同一张表下不能创建相同的字段！");
            }else {
                fieldSet.add(field.getCode());
            }
            field.setIsDele("0");
            if (StringUtil.isEmpty(field.getIsPk())){
                field.setIsPk("0");
            }
            field.setTableId(oldTable.getId());
            field.setResourceName(oldTable.getName());
            field.setResourceCode(oldTable.getCode());
            field.setAttrLength(BeanUtils.isEmpty(field.getAttrLength())?0:field.getAttrLength());
            field.setDecimalLen(BeanUtils.isEmpty(field.getDecimalLen())?0:field.getDecimalLen());
            field.setFieldCode("F_" + field.getCode());
            field.setIsCreate("0");
            field.setId(null);
            return field;
        }).collect(Collectors.toList());
        saveBatch(tableFieldList);
        return tableManager.updateById(oldTable);
    }

    private void addManageField(List<BizShareTableField> fieldList){
        BizShareTableField createBy = new BizShareTableField();
        createBy.setName("创建人");
        createBy.setCode("CREATE_BY_");
        createBy.setDesc("创建人");
        createBy.setDataType("varchar");
        createBy.setAttrLength(200);
        createBy.setIsPk("0");
        createBy.setIsEncrypt("0");
        createBy.setDecimalLen(0);
        createBy.setFieldType("1");
        createBy.setIsDele("0");
        createBy.setSn(100001);

        BizShareTableField createOrgId = new BizShareTableField();
        createOrgId.setName("创建单位");
        createOrgId.setCode("CREATE_ORG_ID_");
        createOrgId.setDesc("创建单位");
        createOrgId.setDataType("varchar");
        createOrgId.setAttrLength(200);
        createOrgId.setIsPk("0");
        createOrgId.setIsEncrypt("0");
        createOrgId.setDecimalLen(0);
        createOrgId.setFieldType("1");
        createOrgId.setIsDele("0");
        createOrgId.setSn(100002);

        BizShareTableField createTime = new BizShareTableField();
        createTime.setName("创建时间");
        createTime.setCode("CREATE_TIME_");
        createTime.setDesc("创建时间");
        createTime.setDataType("date");
        createTime.setAttrLength(0);
        createTime.setIsPk("0");
        createTime.setIsEncrypt("0");
        createTime.setDecimalLen(0);
        createTime.setFieldType("1");
        createTime.setIsDele("0");
        createTime.setSn(100003);

        BizShareTableField id = new BizShareTableField();
        id.setName("主键");
        id.setCode("ID_");
        id.setDesc("主键");
        id.setDataType("varchar");
        id.setAttrLength(500);
        id.setIsPk("1");
        id.setIsEncrypt("0");
        id.setDecimalLen(0);
        id.setFieldType("1");
        id.setIsDele("0");
        id.setSn(-1);

        Set<String> set = fieldList.stream().map(entity -> entity.getCode()).collect(Collectors.toSet());
        if (!set.contains(createBy.getCode())){
            fieldList.add(createBy);
        }
        if (!set.contains(createOrgId.getCode())){
            fieldList.add(createOrgId);
        }
        if (!set.contains(createTime.getCode())){
            fieldList.add(createTime);
        }
        if (!set.contains(id.getCode())){
            fieldList.add(id);
        }
    }

    @Override
    public List<BizShareTableField> queryFieldByTable(String tableId) {
        List<BizShareTableField> fieldList = list(new LambdaQueryWrapper<BizShareTableField>()
                .eq(BizShareTableField::getIsDele, "0")
                .eq(BizShareTableField::getTableId, tableId)
                .orderByAsc(BizShareTableField::getSn));
        return fieldList;
    }

    @Override
    public void importFile(MultipartFile file, String tableId) throws Exception {
        BizShareTable table = tableManager.get(tableId);
        if(null == table){
            throw new ApplicationException("未查询到实体表");
        }
        String tableName=table.getTableCode();
        ExcelTool<ShareTableFieldVo> util = new ExcelTool<>(ShareTableFieldVo.class);
        List<ShareTableFieldVo> list = util.importExcel(file.getInputStream(),2,2);
        list = list.stream().filter(vo-> StringUtil.isNotEmpty(vo.getCode())).collect(Collectors.toList());

        List<BizShareTableField> oldFields = fieldManager.queryFieldByTable(tableId);
        Set<String> manageFields = new HashSet<>();
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0){
            manageFields = oldFields.stream()
                    .filter(entity -> "1".equals(entity.getFieldType()))
                    .map(entity -> entity.getCode())
                    .collect(Collectors.toSet());
        }

        for(int i=1;i<list.size();i++){
            ShareTableFieldVo vo = list.get(i);
            if (manageFields.contains(vo.getCode())){
                continue;
            }
            if(checkExistsField(tableId,vo.getCode())){
                throw new BaseException("表【"+table.getTableNameCh()+"中存在字段("+vo.getName()+")】请修改后在导入");
            }
        }
        List<String> disFieldList=list.stream().map(p->p.getCode()).distinct().collect(Collectors.toList());
        if(disFieldList.size()<list.size()){
            throw new BaseException("表"+table.getTableNameCh()+"中存在重复字段名请修改后在保存");
        }
        for(int i=1;i<list.size();i++){
            ShareTableFieldVo vo = list.get(i);
            if(StringUtil.isEmpty(vo.getCode())){
                continue;
            }
            if (manageFields.contains(vo.getCode())){
                continue;
            }
            BizShareTableField field = vo.parse(vo);
            field.setTableId(tableId);
            field.setFieldCode("F_" + field.getCode());
            //field.setDataType(vo.getDataType());
            //field.setCode(field.getName());
            //field.setDataType(FieldUtil.getColumnType(field.getDataType()));
            if("管理字段".equals(vo.getFieldType())){
                field.setFieldType("1");
            }else if("业务字段".equals(vo.getFieldType())){
                field.setFieldType("2");
            }
            //创建字段
            Integer attrLength=field.getAttrLength()==null ? 0 : field.getAttrLength();
            Integer decimalLen=field.getDecimalLen()==null ? 4 : field.getDecimalLen();
            String fieldSq="ALTER TABLE `"+tableName+"` ADD COLUMN `"+field.getFieldCode()+"` "+ FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) +" NULL COMMENT '"+field.getDesc()+"' ";
            field.setDecimalLen(decimalLen);
            field.setFlSql(fieldSq);
            field.setResourceName(table.getName());
            field.setResourceCode(table.getCode());
            field.setAttrLength(BeanUtils.isEmpty(field.getAttrLength())?0:field.getAttrLength());
            field.setDecimalLen(BeanUtils.isEmpty(field.getDecimalLen())?0:field.getDecimalLen());
            field.setIsDele("0");
            this.create(field);
        }
    }

    public boolean checkExistsField(String tableId,String fieldName){
        QueryWrapper<BizShareTableField> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TABLE_ID",tableId);
        queryWrapper.eq("CODE_",fieldName);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOrUpdateFields(List<BizShareTableField> fields) throws Exception {
        if(fields.size()==0){
            throw  new ApplicationException("没有修改的字段");
        }
        String tableId = fields.get(0).getTableId();
        BizShareTable table = tableManager.get(tableId);
        List<String> disFieldList=fields.stream().map(p->p.getFieldCode()).distinct().collect(Collectors.toList());
        if(disFieldList.size()<fields.size()){
            throw new BaseException("表【"+table.getTableNameCh()+"中存在重复字段名请修改后在保存");
        }
        String tableName=table.getTableCode();
        String dbAlias = table.getDbAlias();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(dbAlias);

        for(BizShareTableField field : fields){
            field.setIsCreate("1");
            //创建字段
            Integer attrLength=field.getAttrLength()==null ? 0 : field.getAttrLength();
            Integer decimalLen=field.getDecimalLen()==null ? 4 : field.getDecimalLen();
            field.setDecimalLen(decimalLen);
            field.setFieldCode(field.getCode());
            //新镇字段
            if(StringUtil.isEmpty(field.getId())){
                if(field.getSn()==null){
                    Map<String,Object> map=new HashMap<>();
                    map.put("TABLE_ID_",tableId);
                    field.setSn(this.getNextSequence(map));
                }
                field.setResourceCode(fields.get(0).getResourceCode());
                field.setResourceName(fields.get(0).getResourceName());
                String fieldSq="ALTER TABLE `"+tableName+"` ADD COLUMN `"+field.getFieldCode()+"` "+ FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) +" NULL COMMENT '"+field.getDesc()+"' ";
                field.setFlSql(fieldSq);
                template.execute(fieldSq);
            }else if(fieldEquals(field)){
                BizShareTableField oldField = this.getById(field.getId());
                //修改字段名
                if(!field.getFieldCode().equals(oldField.getFieldCode())){
                    //ALTER TABLE app_user_info CHANGE COLUMN `USER_PHONE_` `USER_PHONE_1_` varchar COMMENT '移动手机号';
                    //String fieldSq="ALTER TABLE `"+tableName+"` RENAME COLUMN `"+oldField.getFieldCode()+"` "+ field.getFieldCode() +" ";
                    String fieldSq="ALTER TABLE `"+tableName+"` CHANGE `"+oldField.getFieldCode()+"`  `"+ field.getFieldCode() +"` "+FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength,
                            decimalLen)+" DEFAULT NULL COMMENT '"+field.getDesc()+"' ";
                    template.execute(fieldSq);
                }
                //
           /*     if(!field.getFieldCode().equals(oldField.getFieldCode())){
                    //ALTER TABLE app_user_info MODIFY COLUMN `USER_PHONE_` varchar COMMENT '移动手机号';
                    String fieldSq="ALTER TABLE `"+tableName+"` MODIFY COLUMN `"+oldField.getFieldCode()+"` +"+field.getDataType()+" "+field.getDesc()+" ";
                    template.execute(fieldSq);
                }*/
            }
        }
        this.saveOrUpdateBatch(fields);
        //更新建表语句
        String createSql = tableManager.queryTableSql(tableId);
        table.setCreateTableSql(createSql);
        table.setFieldTotal(fields.size());
        this.tableManager.updateById(table);
    }

    //判断传过来的字段是不是修改了
    public boolean fieldEquals(BizShareTableField field){
        BizShareTableField oldField = this.getById(field.getId());
        if(!field.getFieldCode().equals(oldField.getFieldCode())
                || !field.getDesc().equals(oldField.getDesc())
        ){
            return true;
        }
        return false;
    }
}
