package com.artfess.dataShare.dataShare.dao;

import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 数据资产--共享需求方 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-04
 */
public interface BizShareConsumerDao extends BaseMapper<BizShareConsumer> {

    IPage<BizShareConsumer> queryUnAuthByTable(IPage<BizShareConsumer> convert2IPage,
                                               @Param(Constants.WRAPPER) Wrapper<BizShareConsumer> convert2Wrapper,
                                               @Param("tableId") String tableId);

    IPage<BizShareConsumer> queryUnAuthByApi(IPage<BizShareConsumer> convert2IPage,
                                             @Param(Constants.WRAPPER) Wrapper<BizShareConsumer> convert2Wrapper,
                                             @Param("tableId") String tableId,
                                             @Param("resourceId") String resourceId);

    IPage<BizShareConsumer> queryUnAuthByFiles(IPage<BizShareConsumer> convert2IPage,
                                               @Param(Constants.WRAPPER) Wrapper<BizShareConsumer> convert2Wrapper,
                                               @Param("tableId") String tableId,
                                               @Param("resourceId") String resourceId);

    IPage<BizShareAuth> queryTableAuth(IPage<BizShareConsumer> convert2IPage,
                                       @Param(Constants.WRAPPER) Wrapper<BizShareConsumer> convert2Wrapper,
                                       @Param("tableId") String tableId);

    IPage<BizShareAuth> queryAuthByApi(IPage<BizShareConsumer> convert2IPage,
                                       @Param(Constants.WRAPPER) Wrapper<BizShareConsumer> convert2Wrapper,
                                       @Param("tableId") String tableId,
                                       @Param("resourceId") String resourceId);

    IPage<BizShareAuth> queryAuthByFiles(IPage<BizShareConsumer> convert2IPage,
                                         @Param(Constants.WRAPPER) Wrapper<BizShareConsumer> convert2Wrapper,
                                         @Param("tableId") String tableId,
                                         @Param("resourceId") String resourceId);
}
