package com.artfess.dataShare.dataShare.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.dataShare.dataApi.model.BizServiceApi;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataShare.model.BizShareApi;
import com.artfess.dataShare.dataShare.manager.BizShareApiManager;

import java.io.IOException;
import java.sql.SQLException;

/**
 * 数据资源-- 接口共享信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-03
 */
@RestController
@RequestMapping("/biz/dataShare/shareApi/v1/")
@Api(tags = "数据资源--接口共享信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizShareApiController extends BaseController<BizShareApiManager, BizShareApi> {
    @ApiOperation("注册接口配置")
    @PostMapping("register")
    public CommonResult<String> register(@ApiParam(name = "model",value = "实体信息")
                                         @RequestBody
                                         @Validated({AddGroup.class}) BizShareApi shareApi) throws Exception {
        boolean status = this.baseService.register(shareApi);
        return status ? CommonResult.success(null,"注册接口配置成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("验证重复编码")
    @PostMapping("checkApiCode")
    public CommonResult<String> checkApiCode(@ApiParam(name = "model",value = "实体信息")
                                             @RequestBody
                                             @Validated({AddGroup.class}) BizShareApi shareApi) throws SQLException {
        boolean status = this.baseService.checkApiCode(shareApi);
        return status ? CommonResult.success(null,"编码可以使用") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("发布接口")
    @PutMapping("publish")
    public CommonResult<String> publish(@RequestParam String id){
        boolean status = baseService.publish(id);
        return status ? CommonResult.success(null,"发布成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("下架接口")
    @PutMapping("soldOut")
    public CommonResult<String> soldOut(@RequestParam String id){
        boolean status = baseService.soldOut(id);
        return status ? CommonResult.success(null,"下架成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("验证SQL语句的可用性")
    @PostMapping("checkSqlValidity")
    public CommonResult<String> checkSqlValidity(@ApiParam(name = "model",value = "实体信息")
                                                 @RequestBody
                                                 @Validated({AddGroup.class}) BizShareApi shareApi) throws SQLException {
        boolean status = this.baseService.checkSqlValidity(shareApi);
        return status ? CommonResult.success(null,"sql验证成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("验证重复接口")
    @PostMapping("checkApiValidity")
    public CommonResult<String> checkApiValidity(@ApiParam(name = "model",value = "实体信息")
                                                 @RequestBody
                                                 @Validated({AddGroup.class}) BizShareApi shareApi) throws SQLException {
        boolean status = this.baseService.checkApiValidity(shareApi);
        return status ? CommonResult.success(null,"sql验证成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("删除接口配置")
    @DeleteMapping("unregister")
    public CommonResult<String> unregister(@RequestParam("id") String id){
        boolean status = this.baseService.unregister(id);
        return status ? CommonResult.success(null,"删除接口配置成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("修改接口配置")
    @PutMapping("updateServiceApi")
    public CommonResult<String> updateServiceApi(@ApiParam(name = "model",value = "实体信息")
                                                 @RequestBody
                                                 @Validated({UpdateGroup.class}) BizShareApi shareApi){
        boolean status = this.baseService.updateServiceApi(shareApi);
        return status ? CommonResult.success(null,"修改接口配置成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("查询接口配置")
    @PostMapping("/queryApi")
    public PageList<BizShareApi> queryApi(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizShareApi> queryFilter){
        return baseService.queryApi(queryFilter);
    }

    @ApiOperation("查看接口详情")
    @GetMapping("getInfo/{id}")
    public CommonResult<BizServiceApi> getInfo(@PathVariable("id") String id){
        BizShareApi shareApi = this.baseService.getInfo(id);
        return CommonResult.success(shareApi,"获取成功");
    }

    @ApiOperation("浏览接口文档")
    @GetMapping("viewApiDocument/{id}")
    public CommonResult<BizServiceApi> viewApiDocument(@PathVariable("id") String id) throws IOException {
        BizShareApi shareApi = this.baseService.viewApiDocument(id);
        return CommonResult.success(shareApi,"获取成功");
    }

    @PostMapping("queryPageByCatalog")
    @ApiOperation("授权查询-通过目录分页查询接口")
    public PageList<BizShareApi> queryPageByCatalog(@RequestBody QueryFilter<BizShareApi> queryFilter,
                                                    @RequestParam("catalogId") String catalogId,
                                                    @RequestParam("consumerId") String consumerId){
        PageList<BizShareApi> pageList = baseService.queryPageByCatalog(queryFilter, catalogId,consumerId);
        return pageList;
    }
}
