package com.artfess.dataShare.dataResource.ods.model;

import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据采集每日数据采集量汇总统计记录表（每日采集量统计）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-12-18
 */
@ApiModel(value="BizSchedulerCollectDay对象", description="数据采集每日数据采集量汇总统计记录表（每日采集量统计）")
@TableName("BIZ_SCHEDULER_COLLECT_DAY")
public class BizSchedulerCollectDay extends BaseModel<BizSchedulerCollectDay> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "单位名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "系统名称")
    @TableField("SYS_NAME_")
    private String sysName;

    @ApiModelProperty(value = "系统编码")
    @TableField("SYS_CODE_")
    private String sysCode;

    @ApiModelProperty(value = "数据资源项名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "数据资源项编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "数据表名")
    @TableField("TABLE_NAME_")
    private String tableName;

    @ApiModelProperty(value = "数据统计时间")
    @TableField("COUNT_DATE_")
    private LocalDate countDate;

    @ApiModelProperty(value = "表当前数据总量")
    @TableField("TOTAL_NUM_")
    private Long totalNum;

    @ApiModelProperty(value = "统计周期变化总量")
    @TableField("CHANGE_NUM_")
    private Long changeNum;

    @ApiModelProperty(value = "统计周期新增量")
    @TableField("ADD_NUM_")
    private Long addNum;

    @ApiModelProperty(value = "统计周期修改量")
    @TableField("UPDATE_NUM_")
    private Long updateNum;

    @ApiModelProperty(value = "统计周期删除量")
    @TableField("DEL_NUM_")
    private Long delNum;

    @ApiModelProperty(value = "创建日期")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    @TableLogic
    private String isDele;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getSysName() {
        return sysName;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysCode() {
        return sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public LocalDate getCountDate() {
        return countDate;
    }

    public void setCountDate(LocalDate countDate) {
        this.countDate = countDate;
    }

    public Long getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Long totalNum) {
        this.totalNum = totalNum;
    }

    public Long getChangeNum() {
        return changeNum;
    }

    public void setChangeNum(Long changeNum) {
        this.changeNum = changeNum;
    }

    public Long getAddNum() {
        return addNum;
    }

    public void setAddNum(Long addNum) {
        this.addNum = addNum;
    }

    public Long getUpdateNum() {
        return updateNum;
    }

    public void setUpdateNum(Long updateNum) {
        this.updateNum = updateNum;
    }

    public Long getDelNum() {
        return delNum;
    }

    public void setDelNum(Long delNum) {
        this.delNum = delNum;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSchedulerCollectDay{" +
            "id=" + id +
            ", companyName=" + companyName +
            ", sysName=" + sysName +
            ", sysCode=" + sysCode +
            ", name=" + name +
            ", code=" + code +
            ", tableName=" + tableName +
            ", countDate=" + countDate +
            ", totalNum=" + totalNum +
            ", changeNum=" + changeNum +
            ", addNum=" + addNum +
            ", updateNum=" + updateNum +
            ", delNum=" + delNum +
            ", createTime=" + createTime +
            ", isDele=" + isDele +
        "}";
    }
}
