package com.artfess.dataShare.dataResource.ods.model;

import com.artfess.base.entity.AutoOrgFillModel;
import com.baomidou.mybatisplus.annotation.*;

import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据资源-- ODS数据资源项实体表信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-22
 */
@ApiModel(value="BizOdsTable对象", description="数据资源-- ODS数据资源项实体表信息")
@TableName("BIZ_ODS_CATALOGS_TABLE")
public class BizOdsTable extends AutoOrgFillModel<BizOdsTable> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "目录ID")
    @TableField("ODS_CATALOGS_ID_")
    private String odsCatalogsId;

    @ApiModelProperty(value = "数据提供方ID")
    @TableField("CLUSTER_ID_")
    private String clusterId;

    @ApiModelProperty(value = "数据汇聚tableId")
    @TableField("CLUSTER_TABLE_ID_")
    private String clusterTableId;

    @ApiModelProperty(value = "字段总数")
    @TableField("FIELD_TOTAL_")
    private Integer fieldTotal;

    @ApiModelProperty(value = "提供方表前缀命名")
    @TableField("TABLE_PREFIX_CODE_")
    private String tablePrefixCode;

    @ApiModelProperty(value = "数据资源名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "数据资源编码（唯一）")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "数据资源定义描述")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "资源项格式分类（1电子文件2电子表格3数据库4图形图像5流媒体6其它）")
    @TableField("SOURCE_TYPE_")
    private String sourceType;

    @ApiModelProperty(value = "资源项密级程度（1：低，2：中，3：较高，4：高）")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "资源项提供方式（1:数据库，2:接口，3:离线文件，4:消息中间件）")
    @TableField("SOURCE_")
    private String source;

    @ApiModelProperty(value = "库表方式数据源ID（参考数据源ID）")
    @TableField("DB_SOURCE_ID_")
    private String dbSourceId;

    @ApiModelProperty(value = "物理实体表类型（1主表 2子表）")
    @TableField("TABLE_TYPE_")
    private String tableType;

    @ApiModelProperty(value = "物理实体表中文名称")
    @TableField("TABLE_NAME_CH_")
    private String tableNameCh;

    @ApiModelProperty(value = "物理实体表英文名称")
    @TableField("TABLE_NAME_EN_")
    private String tableNameEn;

    @ApiModelProperty(value = "物理实体表描述")
    @TableField("TABLE_DESC_")
    private String tableDesc;

    @ApiModelProperty(value = "物理实体表_数据库表名(唯一)前缀_表英文名")
    @TableField("TABLE_CODE_")
    private String tableCode;

    @ApiModelProperty(value = "实体表创建状态（0：否，1：是）")
    @TableField("IS_CREATE_TABLE_")
    private Integer isCreateTable;

    @ApiModelProperty(value = "表创建SQL语句")
    @TableField("CREATE_TABLE_SQL_")
    private String createTableSql;

    @ApiModelProperty(value = "数据表更新周期（1仅一次，2实时，3每天，4每周，5每月，6每季度，7每年，8不定期）")
    @TableField("UPDATE_RATE_")
    private String updateRate;

    @ApiModelProperty(value = "表当前数据总量")
    @TableField("TOTAL_NUM_")
    private Integer totalNum;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "发布状态（0：未发布，1：已发布）")
    @TableField("DEPLOYED_")
    private Integer deployed;

    @ApiModelProperty(value = "发布日期")
    @TableField("DEPLOYED_TIME_")
    private LocalDateTime deployedTime;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    @TableLogic
    private String isDele;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOdsCatalogsId() {
        return odsCatalogsId;
    }

    public void setOdsCatalogsId(String odsCatalogsId) {
        this.odsCatalogsId = odsCatalogsId;
    }

    public String getClusterId() {
        return clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getClusterTableId() {
        return clusterTableId;
    }

    public void setClusterTableId(String clusterTableId) {
        this.clusterTableId = clusterTableId;
    }

    public Integer getFieldTotal() {
        return fieldTotal;
    }

    public void setFieldTotal(Integer fieldTotal) {
        this.fieldTotal = fieldTotal;
    }

    public String getTablePrefixCode() {
        return tablePrefixCode;
    }

    public void setTablePrefixCode(String tablePrefixCode) {
        this.tablePrefixCode = tablePrefixCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getDbSourceId() {
        return dbSourceId;
    }

    public void setDbSourceId(String dbSourceId) {
        this.dbSourceId = dbSourceId;
    }

    public String getTableType() {
        return tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getTableNameCh() {
        return tableNameCh;
    }

    public void setTableNameCh(String tableNameCh) {
        this.tableNameCh = tableNameCh;
    }

    public String getTableNameEn() {
        return tableNameEn;
    }

    public void setTableNameEn(String tableNameEn) {
        this.tableNameEn = tableNameEn;
    }

    public String getTableDesc() {
        return tableDesc;
    }

    public void setTableDesc(String tableDesc) {
        this.tableDesc = tableDesc;
    }

    public String getTableCode() {
        return tableCode;
    }

    public void setTableCode(String tableCode) {
        this.tableCode = tableCode;
    }

    public Integer getIsCreateTable() {
        return isCreateTable;
    }

    public void setIsCreateTable(Integer isCreateTable) {
        this.isCreateTable = isCreateTable;
    }

    public String getCreateTableSql() {
        return createTableSql;
    }

    public void setCreateTableSql(String createTableSql) {
        this.createTableSql = createTableSql;
    }

    public String getUpdateRate() {
        return updateRate;
    }

    public void setUpdateRate(String updateRate) {
        this.updateRate = updateRate;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public Integer getDeployed() {
        return deployed;
    }

    public void setDeployed(Integer deployed) {
        this.deployed = deployed;
    }

    public LocalDateTime getDeployedTime() {
        return deployedTime;
    }

    public void setDeployedTime(LocalDateTime deployedTime) {
        this.deployedTime = deployedTime;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizOdsTable{" +
                "id='" + id + '\'' +
                ", odsCatalogsId='" + odsCatalogsId + '\'' +
                ", clusterId='" + clusterId + '\'' +
                ", fieldTotal='" + fieldTotal + '\'' +
                ", tablePrefixCode='" + tablePrefixCode + '\'' +
                ", name='" + name + '\'' +
                ", code='" + code + '\'' +
                ", description='" + description + '\'' +
                ", sourceType='" + sourceType + '\'' +
                ", level='" + level + '\'' +
                ", source='" + source + '\'' +
                ", dbSourceId='" + dbSourceId + '\'' +
                ", tableType='" + tableType + '\'' +
                ", tableNameCh='" + tableNameCh + '\'' +
                ", tableNameEn='" + tableNameEn + '\'' +
                ", tableDesc='" + tableDesc + '\'' +
                ", tableCode='" + tableCode + '\'' +
                ", isCreateTable=" + isCreateTable +
                ", createTableSql='" + createTableSql + '\'' +
                ", updateRate='" + updateRate + '\'' +
                ", totalNum=" + totalNum +
                ", sn=" + sn +
                ", deployed=" + deployed +
                ", deployedTime=" + deployedTime +
                ", isDele='" + isDele + '\'' +
                ", tenantId='" + tenantId + '\'' +
                '}';
    }
}
