package com.artfess.dataShare.dataResource.dw.manager.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataResource.dw.dao.BizDwTableDao;
import com.artfess.dataShare.dataResource.dw.manager.BizDwFieldManager;
import com.artfess.dataShare.dataResource.dw.manager.BizDwTableManager;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTable;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTableField;
import com.artfess.dataShare.dataResource.dw.vo.BizDwTableVo;
import com.artfess.dataShare.dataResource.dw.vo.DwTableDetailVo;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.dataShare.factory.QueryDataTableFactory;
import com.artfess.dataShare.factory.QueryParam;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.Constants;
import com.artfess.dataShare.util.DorisUtils;
import com.artfess.dataShare.util.EasyExcelUtil;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 数据资源--Dw数据项信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-13
 */
@Service
public class BizDwTableManagerImpl extends BaseManagerImpl<BizDwTableDao, BizDwdCatalogsTable> implements BizDwTableManager {

    @Resource
    BizDwTableManager dwTableManager;
    @Resource
    BizDwFieldManager dwFieldManager;

/*    @Transactional
    public void saveTable(String catalogId,String tableId) throws Exception{
        //1、读取交换库的模型、表。字段
        BizOdsTable odsTable = this.odsTableManager.getById(tableId);
        BizOdsMould odsMould = this.odsMouldManager.getById(tableId);
        List<BizOdsField> odsFieldList = this.odsFieldManager.queryFieldByTableId(tableId);
        //2、把数据写如到Dw库的数据表
        BizDwMould dwMould=new BizDwMould();
        BizDwTable dwTable=new BizDwTable();
        List<BizDwField> dwFieldList = new ArrayList<>();

        BeanUtils.copyNotNullProperties(dwMould,odsMould);
        BeanUtils.copyNotNullProperties(dwTable,odsMould);
        BeanUtils.copyNotNullProperties(dwFieldList,odsFieldList);
        dwMould.setCatalogId(catalogId);
        dwMouldManager.save(dwMould);
        dwTableManager.save(dwTable);
        dwFieldManager.saveBatch(dwFieldList);

        //3、在Dw库里面创建表和字段
        //JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias("dw");
        DorisUtils.createTable(jdbcTemplate,odsTable.getTableName(),odsFieldList);
    }*/

    /**
     * 批量导入数据资源项目录清单
     * 读取到数据后同时生成【数据汇聚模型信息】和【数据汇聚表信息】两个表
     * 同时往宏天的下列表写入数据
     * 实体表  form_bo_ent
     * 业务模型 form_bo_def
     *
     * 修改form_bo_def表 增加数据源别名
     *
     * @param file
     */
    //@Transactional
    @Transactional(rollbackFor = Exception.class )
    public void export(MultipartFile file,String catalogId) throws Exception {
        ExcelTool<BizDwTableVo> util = new ExcelTool<BizDwTableVo>(BizDwTableVo.class);
        List<BizDwTableVo> list = util.importExcel(file.getInputStream(),3,4);
        //判断表名是否存在
        for(BizDwTableVo vo : list){
            if(StringUtil.isEmpty(vo.getTableNameCh())){
                continue;
            }
            if(StringUtil.isEmpty(vo.getTableNameCh())){
                throw new BaseException("表"+vo.getName()+"中文名不能为空");
            }
            if(StringUtil.isEmpty(vo.getTableNameEn())){
                throw new BaseException("表"+vo.getName()+"英文名不能为空");
            }
            if(checkTable(vo.getCode())){
                throw new BaseException("表【"+vo.getName()+"("+vo.getCode()+")】已经存在");
            }
        }
        for(BizDwTableVo vo : list){
            if(StringUtil.isEmpty(vo.getCode())){
                continue;
            }
            //System.out.println(vo.toString());

            BizDwdCatalogsTable table=vo.parseTable(vo);
           /* Map<String,String> idsMap=createMouldAndTable(vo.getName(),vo.getCode(),vo.getDesc(),"LOCAL");
            mould.setId(idsMap.get("defId"));
            table.setId(idsMap.get("tableId"));*/
            table.setDwCatalogsId(catalogId);
            table.setIsCreateTable("0");
            table.setDeployed("0");
            table.setTableNameEn("dw_"+table.getTableNameEn());
            this.create(table);
        }
    }

    public boolean checkTable(String tableName){
        QueryWrapper<BizDwdCatalogsTable> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TABLE_NAME_EN_",tableName);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    /*public Map<String,String> createMouldAndTable(String name,String code,String desc,String dbAlias) throws IOException {
        //封装json
        Map<String,Object> boDef=new HashMap<>();
        boDef.put("createBy",null);
        boDef.put("createTime",null);
        boDef.put("updateBy",null);
        boDef.put("updateTime",null);
        boDef.put("id","");
        boDef.put("alias",code);
        boDef.put("description",name);
        boDef.put("supportDb", true);
        boDef.put("categoryId","31063");
        boDef.put("categoryName","默认分类");
        boDef.put("status","normal");
        boDef.put("dbAlias",dbAlias);
        boDef.put("deployed",false);
        boDef.put("rev",14);
        boDef.put("pkVal","");


        Map<String,Object> boEnt=new HashMap<>();
        boEnt.put("id","");
        boEnt.put("name",code);
        boEnt.put("desc",name);
        boEnt.put("packageId","");
        boEnt.put("dsName",null);
        boEnt.put("tableName","dw_"+code);
        boEnt.put("isExternal",0);
        boEnt.put("status","actived");
        boEnt.put("pk",null);
        boEnt.put("fk","ref_id_");
        boEnt.put("pk_type",null);
        boEnt.put("type","main");
        boEnt.put("tableNameNoPrefix",null);
        boEnt.put("dbAlias",null);
        boEnt.put("show","主实体");
        boEnt.put("relation","main");
        boEnt.put("canEditTable",false);
        boEnt.put("comment",desc);
        boEnt.put("createdTable",false);
        boEnt.put("external",false);
        boEnt.put("pkKey","id_");
        boEnt.put("fieldPrefix","F_");
        boEnt.put("pkNumber",false);
        boEnt.put("pkVal","");
        boEnt.put("attributeList",new ArrayList<>());
        boEnt.put("childEnts",new ArrayList<>());
        List<Map<String,Object>> boEnts=new ArrayList<>();
        boEnts.add(boEnt);
        boDef.put("boEnt",boEnt);
        boDef.put("ents",boEnts);
        System.out.println(boDef);
        //Map<String,Object> ent=new HashMap<>();
        //ObjectMapper objectMapper=new ObjectMapper();
        //ObjectNode objectNode=objectMapper.convertValue(boDef,ObjectNode.class);

        JsonNode objectNode= JsonUtil.toJsonNode(boDef);
        List<ObjectNode> objectNodes=new ArrayList<>();
        objectNodes.add((ObjectNode)objectNode);

        //objectNodes.add(objectNode);
        FormFeignService formFeignService= AppUtil.getBean(FormFeignService.class);
        Object result=formFeignService.importBoDefNew(objectNodes);
        List<Map<String,Object>> resultMaps=(List<Map<String,Object>>)result;
        String defId=resultMaps.get(0).get("id").toString();
        //返回结果里面没有表ID，所以这里查询一次
        String queryDefSql="select ref_ent_id_ from form_bo_ent_relation where bo_defid_=?";
        String tableId=jdbcTemplate.queryForObject(queryDefSql,new Object[]{defId},String.class);
        System.out.println(result);
        //BoDef boDef = new BoDef();
        //BoEnt boEnt = new BoEnt();
        Map<String,String> map=new HashMap<>();
        map.put("defId",defId);
        map.put("tableId",tableId);
        return map;
    }*/

    //根据表下载导入模板
    public void downloadMainTempFile(HttpServletResponse response, String tableId) throws IOException, Exception {
        BizDwdCatalogsTable dwTable = this.dwTableManager.getById(tableId);
        List<BizDwdCatalogsTableField> field=dwFieldManager.queryFieldByTableId(tableId);
        if(field.size()==0){
            throw new ApplicationException("资源表未设置字段。");
        }
        //物理表
        if("1".equalsIgnoreCase(dwTable.getTableClass())){
            Map<String,String> exportMap = new LinkedHashMap<>();
            for(BizDwdCatalogsTableField field1 : field){
                if("2".equals(field1.getFieldType())) {
                    exportMap.put(field1.getName(), field1.getDesc());
                }
            }
            // 拼装exprotMaps
            HSSFWorkbook book = ExcelUtil.exportExcel(dwTable.getName(), 12, exportMap, new ArrayList<>(), 0);
            ExcelUtil.downloadExcel(book, dwTable.getName() + "_导入模板", response);
            //book.write(new File("D:\\1234.xlsx"));
        }else if("2".equalsIgnoreCase(dwTable.getTableClass())){
            List<List<String>> head=new ArrayList<>();
            //List<String> defaultTitle=new ArrayList<>();
           // defaultTitle.add(dwTable.getName()+"-"+dwTable.getTableNameEn());

            List<String> defaultName=new ArrayList<>();
            defaultName.add(dwTable.getName()+"-"+dwTable.getTableNameEn());
            defaultName.add("个人姓名-USER_NAME_");
            head.add(defaultName);

            List<String> defaultSex=new ArrayList<>();
            defaultSex.add(dwTable.getName()+"-"+dwTable.getTableNameEn());
            defaultSex.add("个人性别-USER_SEX_");
            head.add(defaultSex);

            List<String> defaultCard=new ArrayList<>();
            defaultCard.add(dwTable.getName()+"-"+dwTable.getTableNameEn());
            defaultCard.add("身份证号-USER_IDENTITY_CARD_");
            head.add(defaultCard);

            List<String> defaultPhone=new ArrayList<>();
            defaultPhone.add(dwTable.getName()+"-"+dwTable.getTableNameEn());
            defaultPhone.add("移动手机号-USER_PHONE_");
            head.add(defaultPhone);

            //动态表
            for(BizDwdCatalogsTableField field1 : field){
                if("1".equals(field1.getFieldType())){
                    continue;
                }
                String headStr=field1.getName()+"-"+field1.getFieldCode();
                List<String> fieldHead=new ArrayList<>();
                fieldHead.add(dwTable.getName()+"-"+dwTable.getTableNameEn());
                fieldHead.add(headStr);
                head.add(fieldHead);
            }
            String rootRealPath = (FileUtil.getIoTmpdir() + "/temp/").replace("/", File.separator);
            FileUtil.createFolder(rootRealPath, true);
            String path = rootRealPath+File.separator+System.currentTimeMillis()+".xls";
            System.out.println(path);
            EasyExcel.write(path).head(head).sheet().doWrite(new ArrayList());
            HttpUtil.downLoadFile(response, path, path);
        }
        //book.write(new File("D:\\123.xlsx"));
    }

    //根据表和EXCEL导入数据到表
    @Override
    @Transactional
    public void importMain(MultipartFile file, String tableId) throws Exception {
        BizDwdCatalogsTable dwTable = this.dwTableManager.getById(tableId);
        if("1".equals(dwTable.getTableClass())){
            importWExcelData(file,dwTable);
        }else if("2".equals(dwTable.getTableClass())){
            exportDExcelData(file,dwTable);
        }

    }

    //导入物理表
    @Transactional(rollbackFor = Exception.class )
    public void importWExcelData(MultipartFile file, BizDwdCatalogsTable dwTable) throws Exception {
        List<BizDwdCatalogsTableField> fieldLists=dwFieldManager.queryFieldByTableId(dwTable.getId());
        Map<String, String> nameFieldMap = new HashMap<String, String>();
        for (BizDwdCatalogsTableField field : fieldLists) {//这里同注释的会被覆盖，所以要导入导出的不要出现相同的列注释
            nameFieldMap.put(field.getDesc(), field.getFieldCode());
        }
        List<Map<String, String>> rows = ExcelUtil.ImportDate(file);
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);
        for (Map<String, String> row : rows) {
            StringBuffer sql = new StringBuffer("insert into ");

            List<String> fields = new ArrayList<String>();
            List<String> values = new ArrayList<String>();
            fields.add(BizDwdCatalogsTableField.PK_NAME);
            values.add("'" +UniqueIdUtil.getSuid()+ "'");
            for (Map.Entry<String, String> map : row.entrySet()) {
                //excel单元格有值才去拼接sql
                if (BeanUtils.isNotEmpty(map.getValue())) {
                    String key = map.getKey();
                    String field = this.getFieldName(key, fieldLists, nameFieldMap.get(key));
                    fields.add(field);
                    String dataType = this.getDataType(key, fieldLists, nameFieldMap.get(key));
                    if ("number".equals(dataType)) {
                        values.add("'" +map.getValue()+ "'");
                    } else {
                        values.add("'" + map.getValue() + "'");
                    }
                }

            }
            //加入额外的两个字段
            //fields.add("F_form_data_rev_");
            //values.add("0");

            sql.append(dwTable.getTableNameEn());
            sql.append("(" + String.join(",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + String.join(",", values) + ")");

            jdbcTemplate.execute(sql.toString());
        }
    }

    //导入动态表
    @Transactional(rollbackFor = Exception.class )
    public void exportDExcelData(MultipartFile file, BizDwdCatalogsTable dwTable) throws Exception {
        List<Object> data=EasyExcelUtil.readMoreThan1000Row(file.getInputStream());
        List<BizDwdCatalogsTableField> fields=dwFieldManager.queryFieldByTableId(dwTable.getId());
        fields = fields.stream().filter(p->p.getFieldType().equals("2")).collect(Collectors.toList());
        Map<String,BizDwdCatalogsTableField> fieldMap=fields.stream().collect(Collectors.toMap(p->p.getFieldCode(),p->p));
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);
        String tableName=dwTable.getTableNameEn().replace("dw_","");
        IUser user=ContextUtil.getCurrentUser();
        IGroup org=ContextUtil.getCurrentGroup();
        String uId=user.getUserId();
        String tenantId=user.getTenantId();
        String orgId=org.getGroupId();
        //动态表
        String insertDsql="insert into DWD_BIZ_"+tableName+"_DATA(id_,user_id_,user_name_,USER_SEX_,USER_IDENTITY_CARD_," +
                "USER_PHONE_,DATA_ID_,DATA_JSON_,FIELD_VALUE_TIME_,VERSION,CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_,TENANT_ID_)" +
                " values(?,?,?,?,?,?,?,?,?,?,?,?,now(),?)";
        String recordTable="DWD_"+tableName+"_TABLE_RECORD";

        String insertSql="insert into "+recordTable+ "(id_,user_id_,user_name_,USER_SEX_,USER_IDENTITY_CARD_,USER_PHONE_,DATA_ID_," +
                "FIELD_ID_,FIELD_CODE_,FIELD_VALUE_,FIELD_UI_MODULE_,FIELD_VALUE_TIME_,VERSION,CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_,TENANT_ID_)" +
                " values (?,?,?,?,?,?,?, ?,?,?,?,?,?,?,?,now(),?)";
        List<Object[]> dDataList=new ArrayList<>();
        List<Object[]> rDataList=new ArrayList<>();
        List<String> fieldList=new ArrayList<>();
        for(int i=0;i<data.size();i++){
            List<String> rows= (List<String>) data.get(i);
            if(i==0){
                String title=rows.get(0);
                //tableName=title.substring(title.indexOf("-")+1);
            }else if(i==1){
                for(String field : rows){
                    String fieldName=field.substring(field.indexOf("-")+1);
                    fieldList.add(fieldName);
                }
            }else{
                String pcId = UniqueIdUtil.getSuid();
                //计算批次
                JSONObject jsonObject = new JSONObject();
                //String userId=rows.get(0);
                String userName=rows.get(0);
                String userSex=rows.get(1);
                String userIdentityCard=rows.get(2);
                String userPhone=rows.get(3);
                for(int j=4;j< rows.size();j++){
                    String value=rows.get(j);
                    //System.out.println(fieldList.get(j));
                    jsonObject.put(fieldMap.get(fieldList.get(j)).getFieldCode(),value);
                }
                List<Object> dParam=new ArrayList<>();
                dParam.add(UniqueIdUtil.getSuid());
                dParam.add("");
                dParam.add(userName);
                dParam.add(userSex);
                dParam.add(userIdentityCard);
                dParam.add(userPhone);
                dParam.add(pcId);
                dParam.add(jsonObject.toJSONString());
                dParam.add(LocalDateTime.now());
                dParam.add(1);
                dParam.add(uId);
                dParam.add(orgId);
                dParam.add(tenantId);
                dDataList.add(dParam.toArray());
                //计算字段
                for(int j=4;j< rows.size();j++){
                    String value=rows.get(j);
                    BizDwdCatalogsTableField tableField = fieldMap.get(fieldList.get(j));

                    List<Object> rParam=new ArrayList<>();
                    rParam.add(UniqueIdUtil.getSuid());
                    rParam.add("1");
                    rParam.add(userName);
                    rParam.add(userSex);
                    rParam.add(userIdentityCard);
                    rParam.add(userPhone);
                    rParam.add(pcId);
                    rParam.add(tableField.getId());
                    rParam.add(tableField.getFieldCode());
                    rParam.add(value);
                    rParam.add(tableField.getUiComCode());
                    rParam.add(LocalDateTime.now());
                    rParam.add(1);
                    rParam.add(uId);
                    rParam.add(orgId);
                    rParam.add(tenantId);
                     /*insertSql="insert into "+recordTable+ "(id_,user_id_,user_name_,USER_SEX_,USER_IDENTITY_CARD_,USER_PHONE_,DATA_ID_," +
                            "FIELD_ID_,FIELD_CODE_,FIELD_VALUE_,FIELD_UI_MODULE_,FIELD_VALUE_TIME_,VERSION,CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_,TENANT_ID_)" +
                            "values ('"+UniqueIdUtil.getSuid()+"','1','"+userName+"','"+userSex+"','"+userIdentityCard+"','"+userPhone+"','"+pcId+"'," +
                        "'"+tableField.getId()+"','"+tableField.getFieldCode()+"','"+value+"','"+tableField.getUiComCode()+"','"+LocalDateTime.now()+"','"+1+"','"+uId+"','"+orgId+"',now(),'"+tenantId+"')";
                    jdbcTemplate.execute(insertSql);*/
                    rDataList.add(rParam.toArray());
                }
            }
        }
        jdbcTemplate.batchUpdate(insertDsql,dDataList);
        jdbcTemplate.batchUpdate(insertSql,rDataList);
    }

    private String getFieldName(String key, List<BizDwdCatalogsTableField> columnList, String fieldName) {
        for (BizDwdCatalogsTableField boAtt : columnList) {
            if (boAtt.getDesc().equals(key) || boAtt.getName().equals(fieldName)) {
                return boAtt.getFieldCode();
            }
        }
        return "";
    }

    private String getDataType(String key, List<BizDwdCatalogsTableField> columnList, String fieldName) {
        for (BizDwdCatalogsTableField boAtt : columnList) {
            if (boAtt.getDesc().equals(key) || boAtt.getName().equals(fieldName)) {
                return boAtt.getDataType();
            }
        }
        return "";
    }

    //发布的时候建表
    @Transactional(rollbackFor = Exception.class )
    public void Deploy(String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");
        BizDwdCatalogsTable table= this.getById(tableId);
        String tableDesc = table.getTableDesc() == null ? table.getTableNameCh() : table.getTableDesc();
        String tableName=table.getTableNameEn();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);
        List<BizDwdCatalogsTableField> fieldList = dwFieldManager.queryFieldByTableId(tableId);
        if(fieldList.size()==0){
            throw new ApplicationException("表内没有字段不能发布");
        }
        //物理表
        if("1".equals(table.getTableClass())){
            if("1".equals(table.getDeployed())){
                for(BizDwdCatalogsTableField field : fieldList){
                    if(!"1".equals(field.getIsCreate())){
                        field.setIsCreate("1");
                        //创建字段
                        Integer attrLength=field.getAttrLength()==null ? 0 : field.getAttrLength();
                        Integer decimalLen=field.getDecimalLen()==null ? 4 : field.getDecimalLen();
                        String fieldSq="ALTER TABLE `"+tableName+"` ADD COLUMN `"+field.getFieldCode()+"` "+ FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) +" NULL COMMENT '"+field.getDesc()+"' ";
                        field.setDecimalLen(decimalLen);
                        field.setFlSql(fieldSq);
                        template.execute(fieldSq);
                    }
                }
                //修改字段创建状态
                dwFieldManager.updateBatchById(fieldList);
            }else {
                //List<BizDwdCatalogsTableField> fieldList = dwFieldManager.queryFieldByTableId(tableId);
                for(BizDwdCatalogsTableField field : fieldList){
                    field.setIsCreate("1");
                    Integer attrLength=field.getAttrLength()==null ? 0 : field.getAttrLength();
                    Integer decimalLen=field.getDecimalLen()==null ? 4 : field.getDecimalLen();
                    String fieldSq="ALTER TABLE `"+tableName+"` ADD COLUMN `"+field.getFieldCode()+"` "+ FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) +" NULL COMMENT '"+field.getDesc()+"' ";
                    field.setDecimalLen(decimalLen);
                    field.setFlSql(fieldSq);
                }
                //修改字段创建状态
                dwFieldManager.updateBatchById(fieldList);
                //BizClusterInfo info= this.infoManager.getById(module.getClusterId());
                //BizDatasourcesRelation dataSourcesRelation = dataSourceRelationManager.queryBizDataSourceByType(1);
                //if(null==dataSourcesRelation){
                //    throw new BaseException("未查询到数据源");
                //}
                //获取数据源
                table.setIsCreateTable("1");
                //table.setTableName(table.getTableName());
                table.setCode(table.getTableNameEn());
                table.setDeployed("1");
                table.setDeployedTime(LocalDateTime.now());
                //this.update(table);

                //3、在ods库里面创建表和字段  doris

                String createSql = DorisUtils.createDwTable(template, table.getTableNameEn(),tableDesc, fieldList);
                table.setCreateTableSql(createSql);
                this.update(table);
            }
        }else{
            if(!"1".equals(table.getDeployed())){
                tableName=tableName.replace("dw_","");
                DorisUtils.createDwTable(template,tableName,tableDesc);
                table.setIsCreateTable("1");
                table.setCreateTableSql(DorisUtils.queryDwdMainSql(tableName,tableDesc));
                table.setCreateTableDSql(DorisUtils.queryDwdDetailSql(tableName,tableDesc));
                //table.setTableName(table.getTableName());
                table.setCode(table.getTableNameEn());
                table.setDeployed("1");
                table.setDeployedTime(LocalDateTime.now());
                this.update(table);
            }
            //List<BizDwdCatalogsTableField> fieldList = dwFieldManager.queryFieldByTableId(tableId);
            for(BizDwdCatalogsTableField field : fieldList){
                if(!"1".equals(field.getIsCreate())){
                    field.setIsCreate("1");
                }
            }
            //修改字段创建状态
            dwFieldManager.updateBatchById(fieldList);

        }

       /* BizDwCatalogs moduleType= this.dwCatalogsManager.getById(module.getCatalogId());
        String categoryId=moduleType.getId();//"31063";
        String categoryName=moduleType.getName();//"默认分类";*/
        //2014、12、15 laowang 不同步表到宏天去
        //Map<String,String> idsMap= SyncTableUtil.createDwMouldAndTable(jdbcTemplate,template,table.getId(),module.getId(),table.getName(),table.getTableName(),table.getDesc(),module.getDbAlias(),fieldList,categoryId,categoryName);
        //mould.setId(idsMap.get("defId"));
        //table.setId(idsMap.get("tableId"));
        //table.setMouldId(mould.getId());

        //创建触发器记录日志
        //MySQLUtils.createTiger(template,"dw_"+table.getTableName(),info.getCompanyName(),info.getSysName(),info.getSysCode(),table.getName(),table.getCode());
    }

    public DwTableDetailVo queryTableVo(String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");
        DwTableDetailVo vo = new DwTableDetailVo();
        BizDwdCatalogsTable table=this.getById(tableId);
        if(null==table){
            throw new BaseException("未查询到表");
        }
        vo.setTable(table);
        vo.setFieldList(this.dwFieldManager.queryFieldByTableId(tableId));
        return vo;
    }

    public QueryResultData queryTableData (QueryParamVo queryParamVo) throws Exception{
        Assert.hasText(queryParamVo.getTableId(),"表ID不能为空");
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties(queryParam,queryParamVo);

        BizDwdCatalogsTable table= null;
        if(StringUtil.isNotEmpty(queryParam.getTableId())){
            table = this.getById(queryParam.getTableId());
        }else {
            QueryWrapper<BizDwdCatalogsTable> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("TABLE_NAME_EN_", queryParamVo.getTableName());
            table = this.baseMapper.selectOne(queryWrapper);
        }

        if(table == null){
            return null;
        }
        queryParam.setTableName(table.getTableNameEn());
        List<BizDwdCatalogsTableField> fieldList = dwFieldManager.queryFieldByTableId(table.getId());
        //只提取业务字段
        Map<String,String> field = fieldList.stream().filter(p->"2".equals(p.getFieldType())).collect(Collectors.toMap(BizDwdCatalogsTableField::getFieldCode, p->p.getName()));
        if(queryParam.getPageNo()==0){
            field = fieldList.stream().collect(Collectors.toMap(BizDwdCatalogsTableField::getFieldCode, p->p.getName()));
        }
        field.put("id_","主键");
        queryParam.setField(field);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);

        /*BizDatasourcesRelation dataSourcesRelation = dataSourceRelationManager.queryBizDataSourceByType(1);
        if(null==dataSourcesRelation){
            throw new BaseException("未查询到数据源");
        }
        //获取共享库数据源
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(dataSourcesRelation.getAlias());*/
        queryParam.setJdbcTemplate(template);
        queryParam.setDbType("mysql");
        return QueryDataTableFactory.getTableData(queryParam);
    }

    @Transactional(rollbackFor = Exception.class )
    public void removeTable(String tableId) throws Exception {
        BizDwdCatalogsTable table=this.getById(tableId);
        //如果表已经发布，删除实体表
        if("1".equals(table.getDeployed()) && "1".equals(table.getTableClass())){
            boolean exists = checkPhysicsTableExists(table.getTableNameEn());
            if (exists){
                String dropSql="drop table "+table.getTableNameEn();
                JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);
                template.execute(dropSql);
            }
        }else if("1".equals(table.getDeployed()) && "1".equals(table.getTableClass())){
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);
            //动态两个表
            String dataTable="DWD_BIZ_"+table.getTableNameEn()+"_DATA";
            String recordTable="DWD_"+table.getTableNameEn()+"_TABLE_RECORD";

            boolean mainExists = checkPhysicsTableExists(table.getTableNameEn());
            if (mainExists){
                String dropSql="drop table "+dataTable;
                template.execute(dropSql);
            }

            boolean recordExists = checkPhysicsTableExists(table.getTableNameEn());
            if (recordExists){
                String dropSql1="drop table "+recordTable;
                template.execute(dropSql1);
            }
        }
        QueryWrapper<BizDwdCatalogsTableField> queryWrapper=new QueryWrapper();
        queryWrapper.eq("table_id_",tableId);
        this.removeById(tableId);
        dwFieldManager.remove(queryWrapper);
    }

    @Transactional
    public QueryResultData queryDTTableData(QueryParamVo queryParamVo) throws Exception{
        //Assert.hasText(queryParamVo.getTableId(),"表ID不能为空");
        if(StringUtil.isEmpty(queryParamVo.getTableId()) && StringUtil.isEmpty(queryParamVo.getTableName())){
            throw new ApplicationException("表ID或者表名不能为空");
        }
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties(queryParam,queryParamVo);
        BizDwdCatalogsTable table= null;
        if(StringUtil.isNotEmpty(queryParam.getTableId())){
            table = this.getById(queryParam.getTableId());
        }else {
            QueryWrapper<BizDwdCatalogsTable> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("TABLE_NAME_EN_", queryParamVo.getTableName());
            table = this.baseMapper.selectOne(queryWrapper);
        }

        if(table == null){
            return null;
        }
        queryParam.setTableName(table.getTableNameEn());
        List<BizDwdCatalogsTableField> fieldList = dwFieldManager.queryFieldByTableId(table.getId());
        //只提取业务字段
        Map<String,String> field = fieldList.stream().filter(p->"2".equals(p.getFieldType())).collect(Collectors.toMap(BizDwdCatalogsTableField::getFieldCode, p->p.getName()));
        field.put("id_","主键");
        if(queryParam.getPageNo()==0){
            field = fieldList.stream().collect(Collectors.toMap(BizDwdCatalogsTableField::getFieldCode, p->p.getName()));
        }

        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);
        Integer pageNo=queryParamVo.getPageNo();
        Integer pageSize=queryParamVo.getPageSize();
        String order = queryParamVo.getOrder();
        String tableName=table.getTableNameEn();
        Map<String,String> paramMap= queryParamVo.getParam();
        tableName=tableName.replace("dw_","");
        QueryResultData resultData = new QueryResultData();
        String querySql="select * from DWD_BIZ_"+tableName+"_DATA where 1=1";
        String querySqlCount="select count(*) from DWD_BIZ_"+tableName+"_DATA where 1=1";
        for(String key : paramMap.keySet()){
            querySql+=" and "+key+" = '"+paramMap.get(key)+"'";
            querySqlCount+=" and "+key+" = '"+paramMap.get(key)+"'";
        }
        if(pageNo>0) {
            int total=template.queryForObject(querySqlCount, Integer.class);
            resultData.setTotal(total);
        }
        if(StringUtil.isNotEmpty(order)){
            querySql+=" order by "+order;
        }else{
            querySql+=" order by create_time_";
        }
        if(pageNo>1) {
            querySql += " limit " + ((pageNo - 1) * pageSize) + "," + pageSize;
        }
        resultData.setData(template.queryForList(querySql));
        resultData.setField(field);

        return resultData;
    }

    public Map<String,Object> queryTableDetailData(String tableId,String pcId) throws Exception{
        BizDwdCatalogsTable table= this.getById(tableId);
        String tableName=table.getTableNameEn().replace("dw_","");;
        List<BizDwdCatalogsTableField> fieldList = dwFieldManager.queryFieldByTableId(tableId);
        String querySql="select * from DWD_"+tableName+"_TABLE_RECORD where DATA_ID_= ? ";
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);
        List<Map<String, Object>> data = template.queryForList(querySql,new Object[]{pcId});
        Map<String,Object> result=new HashMap<>();
        result.put("data",data);
        result.put("field",fieldList);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class )
    public void deployHaveTable(String tableId) throws Exception {
        BizDwdCatalogsTable table = this.get(tableId);
        if("1".equals(table.getDeployed())){
            throw new ApplicationException("表已经发布，不能从重复，如果有问题请联系管理员");
        }
        table.setIsCreateTable("1");
        table.setDeployed("1");
        table.setDeployedTime(LocalDateTime.now());
        this.update(table);
    }

    @Override
    @Transactional(rollbackFor = Exception.class )
    public void deployDotHaveTable(String tableId,String tableSql,String detailTableSql) throws Exception {
        BizDwdCatalogsTable table = this.get(tableId);
        List<BizDwdCatalogsTableField> tableFields = dwFieldManager.queryFieldByTableId(tableId);
        if("1".equals(table.getDeployed())){
            throw new ApplicationException("表已经发布，不能从重复，如果有问题请联系管理员");
        }
        if(tableFields.size()==0){
            throw new ApplicationException("表内没有字段不能发布");
        }
        table.setCreateTableSql(tableSql);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);
        table.setIsCreateTable("1");
        table.setDeployed("1");
        table.setDeployedTime(LocalDateTime.now());
        table.setCreateTableSql(tableSql);
        if ("2".equals(table.getTableClass())){
            table.setCreateTableDSql(detailTableSql);
            template.execute(table.getCreateTableDSql());
        }
        template.execute(table.getCreateTableSql());
        this.update(table);
    }

    @Override
    public boolean checkTableExists(String tableNameEn) throws Exception{
        tableNameEn="dw_"+tableNameEn.replaceFirst("dw_","");
        //查询表库是否存在
        if(checkTable(tableNameEn)){
            return true;
        }
        //查询数据库是否存在
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);
        String sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'";
        return template.queryForObject(sql, Integer.class) > 0 ? true : false;
    }

    @Override
    public boolean checkPhysicsTableExists(String tableNameEn) throws Exception {
        //查询数据库是否存在
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.DWD_DATA_SOURCE_ALIAS);
        String sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'";
        return template.queryForObject(sql, Integer.class) > 0 ? true : false;
    }

    @Override
    public Map<String, String> queryDwTable(String tableId) {
        BizDwdCatalogsTable table = get(tableId);
        Map<String,String> result = new HashMap<>();
        String dwdMainSql = DorisUtils.queryDwdMainSql(table.getTableNameEn(),table.getTableDesc());
        String dwdDetailSql = DorisUtils.queryDwdDetailSql(table.getTableNameEn(),table.getTableDesc());
        result.put("dwdMainSql",dwdMainSql);
        result.put("dwdDetailSql",dwdDetailSql);
        return result;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateCatalog(String[] ids, String catalogId) {
        int count = baseMapper.updateCatalog(ids,catalogId);
        return count > 0 ? true : false;
    }
}
