package com.artfess.dataShare.dataResource.app.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * APP层数据清洗治理每次日志记录表 ( 由Dolphin任务执行后写入)
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-12-27
 */
@ApiModel(value="BizAppDataCleanLogs对象", description="APP层数据清洗治理每次日志记录表 ( 由Dolphin任务执行后写入)")
@TableName("BIZ_APP_DATA_CLEAN_LOGS")
public class BizAppDataCleanLogs extends BaseModel<BizAppDataCleanLogs> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "DS项目名称")
    @TableField("DS_PROJECT_NAME_")
    private String dsProjectName;

    @ApiModelProperty(value = "DS工作流名称")
    @TableField("DS_WORKFLOW_NAME_")
    private String dsWorkflowName;

    @ApiModelProperty(value = "DS节点任务名称")
    @TableField("DS_TASKNODE_NAME_")
    private String dsTasknodeName;

    @ApiModelProperty(value = "数据资源项编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "数据资源项名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "数据表名")
    @TableField("TABLE_NAME_")
    private String tableName;

    @ApiModelProperty(value = "计算治理方式（1全量计算 2增量计算）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "本次增量的开始时间值（计算的这个时间后的数据）")
    @TableField("INCREMENT_DATETIME_")
    private LocalDateTime incrementDatetime;

    @ApiModelProperty(value = "本次治理周期清洗治理时间")
    @TableField("START_TIME_")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "本次治理周期清洗治理时间")
    @TableField("END_TIME_")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "数据每次清洗治理状态（0失败 1成功）")
    @TableField("CLEAN_STATUS_")
    private String cleanStatus;

    @ApiModelProperty(value = "计算后当前表数据剩余总数量")
    @TableField("TOTAL_NUM_")
    private Integer totalNum;

    @ApiModelProperty(value = "统计周期变化总量")
    @TableField("CHANGE_NUM_")
    private Integer changeNum;

    @ApiModelProperty(value = "统计周期新增量")
    @TableField("ADD_NUM_")
    private Integer addNum;

    @ApiModelProperty(value = "统计周期修改量")
    @TableField("UPDATE_NUM_")
    private Integer updateNum;

    @ApiModelProperty(value = "统计周期删除量")
    @TableField("DEL_NUM_")
    private Integer delNum;

    @ApiModelProperty(value = "日志创建日期")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDsProjectName() {
        return dsProjectName;
    }

    public void setDsProjectName(String dsProjectName) {
        this.dsProjectName = dsProjectName;
    }

    public String getDsWorkflowName() {
        return dsWorkflowName;
    }

    public void setDsWorkflowName(String dsWorkflowName) {
        this.dsWorkflowName = dsWorkflowName;
    }

    public String getDsTasknodeName() {
        return dsTasknodeName;
    }

    public void setDsTasknodeName(String dsTasknodeName) {
        this.dsTasknodeName = dsTasknodeName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LocalDateTime getIncrementDatetime() {
        return incrementDatetime;
    }

    public void setIncrementDatetime(LocalDateTime incrementDatetime) {
        this.incrementDatetime = incrementDatetime;
    }

    public LocalDateTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public String getCleanStatus() {
        return cleanStatus;
    }

    public void setCleanStatus(String cleanStatus) {
        this.cleanStatus = cleanStatus;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getChangeNum() {
        return changeNum;
    }

    public void setChangeNum(Integer changeNum) {
        this.changeNum = changeNum;
    }

    public Integer getAddNum() {
        return addNum;
    }

    public void setAddNum(Integer addNum) {
        this.addNum = addNum;
    }

    public Integer getUpdateNum() {
        return updateNum;
    }

    public void setUpdateNum(Integer updateNum) {
        this.updateNum = updateNum;
    }

    public Integer getDelNum() {
        return delNum;
    }

    public void setDelNum(Integer delNum) {
        this.delNum = delNum;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAppDataCleanLogs{" +
            "id=" + id +
            ", dsProjectName=" + dsProjectName +
            ", dsWorkflowName=" + dsWorkflowName +
            ", dsTasknodeName=" + dsTasknodeName +
            ", code=" + code +
            ", name=" + name +
            ", tableName=" + tableName +
            ", type=" + type +
            ", incrementDatetime=" + incrementDatetime +
            ", startTime=" + startTime +
            ", endTime=" + endTime +
            ", cleanStatus=" + cleanStatus +
            ", totalNum=" + totalNum +
            ", changeNum=" + changeNum +
            ", addNum=" + addNum +
            ", updateNum=" + updateNum +
            ", delNum=" + delNum +
            ", createTime=" + createTime +
        "}";
    }
}
