package com.artfess.dataShare.dataResource.app.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.dataShare.dataResource.app.vo.BizAppTableDetailVo;
import com.artfess.dataShare.dataResource.dw.vo.DwTableDetailVo;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.DorisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTable;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsTableManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 数据应用层--APP层应用层表管理 （TABLE） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-18
 */
@RestController
@RequestMapping("/biz/app/catalogs/table/v1/")
@Api(tags = "数据应用层表--APP层应用层表管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizAppCatalogsTableController extends BaseController<BizAppCatalogsTableManager, BizAppCatalogsTable> {

    @Resource
    BizAppCatalogsTableManager tableManager;

    @PostMapping("/")
    @ApiOperation("添加实体接口")
    @Override
    public CommonResult<String> create(@RequestBody BizAppCatalogsTable table) {
        boolean result = baseService.saveInfo(table);
        if (!result){
            return new CommonResult<>(false,"添加失败");
        }
        return new CommonResult<>(true,"添加成功");
    }

    @PostMapping(value = "/queryTableVo")
    @ApiOperation("根据表查询表信息、字段信息、模型")
    public BizAppTableDetailVo queryTableVo(@RequestParam(value = "tableId", required = true) String tableId) throws Exception {
        BizAppTableDetailVo vo=this.tableManager.queryTableVo(tableId);
        return vo;
    }

    @PostMapping("/importFile")
    @ApiOperation(value = "导入数据资产-APP数据项", httpMethod = "POST", notes = "导入数据资产-DW数据项")
    public CommonResult export(@RequestParam(value = "file", required = true) MultipartFile file, String catalogId) throws Exception {
        this.tableManager.export(file,catalogId);
        return new CommonResult<>("导入主表成功");
    }

    @RequestMapping(value = "downloadMainTempFile/{tableId}", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "下载导入的模板", httpMethod = "POST", notes = "下载导入的模板")
    public void downloadMainTempFile(HttpServletResponse response,
                                     @ApiParam(name = "tableId", value = "模板别名", required = true) @PathVariable String tableId) throws Exception {
        baseService.downloadMainTempFile(response, tableId);
    }

    @PostMapping(value = "importMain", produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导入主表数据", httpMethod = "POST", notes = "导入主表数据")
    public CommonResult<String> importMain(@ApiParam(name = "file", value = "上传的文件流") @RequestBody MultipartFile file,
                                           @ApiParam(name = "tableId", value = "数据模板別名") @RequestParam String tableId) throws Exception {
        baseService.importMain(file, tableId);
        return new CommonResult<>("导入主表数据成功");
    }

    @PostMapping(value = "/Deploy")
    @ApiOperation("发布表创建实体表")
    public CommonResult Deploy(@RequestParam(value = "tableId", required = true) String tableId) throws Exception {
        this.tableManager.Deploy(tableId);
        return new CommonResult<String>(true, "操作成功");
    }

    @PostMapping(value = "/queryTableData")
    @ApiOperation("数据查询  分页，加搜索、排序")
    public QueryResultData queryTableData(@RequestBody QueryParamVo queryParamVo) throws Exception {
        return this.tableManager.queryTableData(queryParamVo);
    }

    @PostMapping(value = "/queryDTTableData")
    @ApiOperation("动态表 数据查询")
    public QueryResultData queryDTTableData(@RequestBody QueryParamVo queryParamVo) throws Exception {
        return this.tableManager.queryDTTableData(queryParamVo);
    }

    @PostMapping(value = "/queryTableDetailData")
    @ApiOperation("动态表 明细数据查询")
    public Map<String,Object> queryTableDetailData(String tableId,String pcId) throws Exception {
        return this.tableManager.queryTableDetailData(tableId,pcId);
    }

    @PostMapping(value = "/removeTable")
    @ApiOperation("删除表和字段")
    public CommonResult queryTableData(@RequestParam String tableId) throws Exception {
        this.tableManager.removeTable(tableId);
        return new CommonResult<String>(true, "操作成功");
    }

    @PostMapping(value = "/queryTableSql/{tableId}")
    @ApiOperation("根据表建表语句")
    public CommonResult<String> queryTableSql(@PathVariable String tableId) throws Exception {
        BizAppTableDetailVo vo=this.tableManager.queryTableVo(tableId);
        if(StringUtils.isNotBlank(vo.getTable().getCreateTableSql())){
            return CommonResult.success(vo.getTable().getCreateTableSql(),"获取成功");
        }
        String tableDesc = vo.getTable().getTableDesc() == null ? vo.getTable().getTableNameCh() : vo.getTable().getTableDesc();
        String sql= DorisUtils.getAPPTableSql(vo.getTable().getTableNameEn(),tableDesc,vo.getFieldList());
        return CommonResult.success(sql,"获取成功");
    }

    @PostMapping(value = "/queryDtTableSql/{tableId}")
    @ApiOperation("获取动态表表建表语句")
    public CommonResult<Map<String,String>> queryDtTableSql(@PathVariable String tableId) throws Exception {
//        BizDwdCatalogsTable table= this.tableManager.getById(tableId);
//        Map<String,String> result=queryDwTable(table.getTableNameEn());
        Map<String,String> result = baseService.queryAppTable(tableId);
        return CommonResult.success(result,"获取成功");
    }

    @PostMapping(value = "checkTableExists", produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "验证表是否已经存在", httpMethod = "POST", notes = "验证表是否已经存在")
    public CommonResult<String> checkTableExists(@ApiParam(name = "tableNameEn", value = "表英文名") @RequestParam String tableNameEn,
                                                 @ApiParam(name = "type", value = "发布类型(0:未有表发布，1:已有表发布)") @RequestParam(required = false) String type) throws Exception {
        boolean isExists=tableManager.checkTableExists(tableNameEn);
        if ("1".equals(type)){
            if(isExists){
                return new CommonResult<>(true,"验证成功，可以发布");
            }
            return new CommonResult<>(false,"表"+tableNameEn+"不存在！");
        }
        if(isExists){
            return new CommonResult<>(false,"表"+tableNameEn+"已经存在，请更换表名");
        }
        return new CommonResult<>(true,"可以使用表名");
    }

    @PostMapping(value = "checkPhysicsTableExists", produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "验证物理表是否已经存在", httpMethod = "POST", notes = "验证表是否已经存在")
    public CommonResult<String> checkPhysicsTableExists(@ApiParam(name = "tableNameEn", value = "表英文名") @RequestParam String tableNameEn,
                                                        @ApiParam(name = "type", value = "发布类型(0:未有表发布，1:已有表发布)") @RequestParam(required = false) String type) throws Exception {
        boolean isExists=tableManager.checkPhysicsTableExists(tableNameEn);
        if ("1".equals(type)){
            if(isExists){
                return new CommonResult<>(true,"验证成功，可以发布");
            }
            return new CommonResult<>(false,"表"+tableNameEn+"不存在！");
        }
        if(isExists){
            return new CommonResult<>(false,"表"+tableNameEn+"已经存在，请更换表名");
        }
        return new CommonResult<>(true,"可以使用表名");
    }

    @PostMapping(value = "saveTableSql", produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存建表SQL", httpMethod = "POST", notes = "保存建表SQL")
    public CommonResult<String> saveTableSql(@ApiParam(name = "tableId", value = "数据表ID") @RequestParam String tableId,
                                             @ApiParam(name = "tableSql", value = "建表语句") @RequestParam String tableSql) throws Exception {
        BizAppCatalogsTable table=tableManager.getById(tableId);
        table.setCreateTableSql(tableSql);
        tableManager.updateById(table);
        return new CommonResult<>(true,"保存建表SQL成功");
    }

    @RequestMapping(value = "deployHaveTable", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "已有表发布", httpMethod = "POST", notes = "已有表发布")
    public CommonResult<String> deployHaveTable(@ApiParam(name = "tableId", value = "数据表ID") @RequestParam String tableId) throws Exception {
        tableManager.deployHaveTable(tableId);
        return new CommonResult<>(true,"已有表发布成功");
    }

    @RequestMapping(value = "deployDotHaveTable", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "未有表发布", httpMethod = "POST", notes = "未有表发布")
    public CommonResult<String> deployDotHaveTable(@ApiParam(name = "tableId", value = "数据表ID") @RequestParam String tableId,
                                                   @ApiParam(name = "tableSql", value = "建表语句") @RequestParam String tableSql,
                                                   @ApiParam(name = "detailTableSql", value = "明细表建表语句",required = false) @RequestParam String detailTableSql) throws Exception {
        tableManager.deployDotHaveTable(tableId,tableSql,detailTableSql);
        return new CommonResult<>(true,"未有表发布");
    }

    @RequestMapping(value = "updateCatalog", method = RequestMethod.PUT, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改表资源目录", httpMethod = "PUT", notes = "修改表资源目录")
    public CommonResult<String> updateCatalog(@RequestParam String[] ids,@RequestParam String catalogId){
        boolean result = tableManager.updateCatalog(ids,catalogId);
        if (result){
            return new CommonResult<>(true,"操作成功");
        }
        return new CommonResult<>(false,"操作失败");
    }
}
