package com.artfess.dataShare.dataCollect.vo;

import com.artfess.base.annotation.ExcelColumn;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.artfess.base.util.BeanUtils;
import com.artfess.dataShare.dataCollect.model.BizClusterInfo;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class BizClusterInfoVo {

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "单位名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "单位类型（1：外部单位，2：内部单位）")
    @TableField("COMPANY_TYPE_")
    private Integer companyType;

    @ApiModelProperty(value = "系统名称")
    @TableField("SYS_NAME_")
    private String sysName;

    @ApiModelProperty(value = "系统编码")
    @TableField("SYS_CODE_")
    private String sysCode;

    @ApiModelProperty(value = "系统表定义前缀命名")
    @TableField("SYS_TABLE_CODE_")
    private String sysTableCode;

    @ApiModelProperty(value = "联系人")
    @TableField("LINK_USER_")
    private String linkUser;

    @ApiModelProperty(value = "联系电话")
    @TableField("LINK_PHONE_")
    private String linkPhone;

    @ApiModelProperty(value = "'数据提供描述'")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "'是否开启数据库提供方式（0：否，1：是）'")
    @TableField("IS_DATABASE_")
    private String isDatabase;

    @ApiModelProperty(value = "'是否开启API提供方式（0：否，1：是）'")
    @TableField("IS_API_")
    private String isApi;

    @ApiModelProperty(value = "'是否开启离线文件提供方式（0：否，1：是）'")
    @TableField("IS_FILE_")
    private String isFile;

    @ApiModelProperty(value = "'是否开启消息中间件提供方式（0：否，1：是）'")
    @TableField("IS_MQ_")
    private String isMq;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDelete",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    protected String isDele = "0";

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getCompanyType() {
        return companyType;
    }

    public void setCompanyType(Integer companyType) {
        this.companyType = companyType;
    }

    public String getSysName() {
        return sysName;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysCode() {
        return sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getLinkUser() {
        return linkUser;
    }

    public void setLinkUser(String linkUser) {
        this.linkUser = linkUser;
    }

    public String getLinkPhone() {
        return linkPhone;
    }

    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIsDatabase() {
        return isDatabase;
    }

    public void setIsDatabase(String isDatabase) {
        this.isDatabase = isDatabase;
    }

    public String getIsApi() {
        return isApi;
    }

    public void setIsApi(String isApi) {
        this.isApi = isApi;
    }

    public String getIsFile() {
        return isFile;
    }

    public void setIsFile(String isFile) {
        this.isFile = isFile;
    }

    public String getIsMq() {
        return isMq;
    }

    public void setIsMq(String isMq) {
        this.isMq = isMq;
    }

    public String getSysTableCode() {
        return sysTableCode;
    }

    public void setSysTableCode(String sysTableCode) {
        this.sysTableCode = sysTableCode;
    }

    @ApiModelProperty(value = "数据库连接源别名")
    @TableField("SOURCE_ALIAS_")
    private String sourceAlias;

    @ApiModelProperty(value = "数据库源别名")
    @TableField("DATABASE_ALIAS_")
    private String databaseAlias;

    @ApiModelProperty(value = "数据库类型（mysql,sqlserver,pgsql,）")
    @TableField("DATABASE_TYPE_")
    private String databaseType;

    @ApiModelProperty(value = "数据库实例名称（统一实例名interchange_library）")
    @TableField("DATABASE_NAME_")
    private String databaseName;

    @ApiModelProperty(value = "数据库连接地址")
    @TableField("DATABASE_URL_")
    private String databaseUrl;

    @ApiModelProperty(value = "数据库登录用户名")
    @TableField("DATABASE_USER_")
    private String databaseUser;

    @ApiModelProperty(value = "数据库登录密码")
    @TableField("DATABASE_PWD_")
    private String databasePwd;

    @ApiModelProperty(value = "数据文件提供格式(参考字典例如csv、xls)")
    @TableField("DATA_TYPE_")
    private String dataType;

    @ApiModelProperty(value = "API接口IP地址端口")
    @TableField("API_UTL_PORT_")
    private String apiUtlPort;

    @ApiModelProperty(value = "API接口IP地址端口")
    @TableField("API_AK_")
    private String apiAk;

    @ApiModelProperty(value = "API访问AK")
    @TableField("API_SK_")
    private String apiSk;

    @ApiModelProperty(value = "API访问SK")
    @TableField("KAFA_COLONY_")
    private String kafaColony;

    @ApiModelProperty(value = "Kafka消息者组")
    @TableField("KAFA_MESSAGE_GROUP_")
    private String kafaMessageGroup;

    public String getSourceAlias() {
        return sourceAlias;
    }

    public void setSourceAlias(String sourceAlias) {
        this.sourceAlias = sourceAlias;
    }

    public String getDatabaseAlias() {
        return databaseAlias;
    }

    public void setDatabaseAlias(String databaseAlias) {
        this.databaseAlias = databaseAlias;
    }

    public String getDatabaseType() {
        return databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseName() {
        return databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseUrl() {
        return databaseUrl;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getDatabaseUser() {
        return databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePwd() {
        return databasePwd;
    }

    public void setDatabasePwd(String databasePwd) {
        this.databasePwd = databasePwd;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getApiUtlPort() {
        return apiUtlPort;
    }

    public void setApiUtlPort(String apiUtlPort) {
        this.apiUtlPort = apiUtlPort;
    }

    public String getApiAk() {
        return apiAk;
    }

    public void setApiAk(String apiAk) {
        this.apiAk = apiAk;
    }

    public String getApiSk() {
        return apiSk;
    }

    public void setApiSk(String apiSk) {
        this.apiSk = apiSk;
    }

    public String getKafaColony() {
        return kafaColony;
    }

    public void setKafaColony(String kafaColony) {
        this.kafaColony = kafaColony;
    }

    public String getKafaMessageGroup() {
        return kafaMessageGroup;
    }

    public void setKafaMessageGroup(String kafaMessageGroup) {
        this.kafaMessageGroup = kafaMessageGroup;
    }


    public static BizClusterInfo parse(BizClusterInfoVo roleVo){
        BizClusterInfo vo = new BizClusterInfo();
        try {
            BeanUtils.copyNotNullProperties(vo,roleVo);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return vo;
    }

    public static BizClusterInfoMode parseMode(BizClusterInfoVo roleVo){
        BizClusterInfoMode vo = new BizClusterInfoMode();
        try {
            BeanUtils.copyNotNullProperties(vo,roleVo);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return vo;
    }
}
