package com.artfess.dataShare.dataCollect.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据变化临时表（用于数据变化统计）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-18
 */
@ApiModel(value="BizClusterDataLog对象", description="数据汇聚方信息")
@TableName("BIZ_CLUSTER_TEMP_DATA")
public class BizClusterTempData extends BaseModel<BizClusterTempData> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "单位名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "系统名称")
    @TableField("SYS_NAME_")
    private String sysName;

    @ApiModelProperty(value = "系统编码")
    @TableField("SYS_CODE_")
    private String sysCode;

    @ApiModelProperty(value = "数据表名")
    @TableField("TABLE_NAME_")
    private String tableName;

    @ApiModelProperty(value = "数据表ID")
    @TableField("SRC_ID_")
    private String srcId;

    @ApiModelProperty(value = "数据操作标记（1：新增，2：修改，3：删除）")
    @TableField("DATA_TYPE_")
    private Integer dataType;

    @ApiModelProperty(value = "数据操作时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getSysName() {
        return sysName;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysCode() {
        return sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSrcId() {
        return srcId;
    }

    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public Integer getDataType() {
        return dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizClusterDataLog{" +
            "id=" + id +
            ", companyName=" + companyName +
            ", sysName=" + sysName +
            ", sysCode=" + sysCode +
            ", tableName=" + tableName +
            ", srcId=" + srcId +
            ", dataType=" + dataType +
            ", createTime=" + createTime +
        "}";
    }
}
