package com.artfess.dataShare.dataApi.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 数据资产-数据服务接口调用日志
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-11-28
 */
@ApiModel(value="BizServiceApiLog对象", description="数据资产-数据服务接口调用日志")
@TableName("BIZ_SERVICE_API_LOG")
@Data
public class BizServiceApiLog extends BaseModel<BizServiceApiLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "调用访问的接口_ID")
    @TableField("API_ID_")
    private String apiId;

    @ApiModelProperty(value = "调用访问的接口_名称")
    @TableField("API_NAME_")
    private String apiName;

    @ApiModelProperty(value = "调用访问的接口_地址")
    @TableField("API_URL_")
    private String apiUrl;

    @ApiModelProperty(value = "客户端访问的_IP地址")
    @TableField("REQUEST_IP_")
    private String requestIp;

    @ApiModelProperty(value = "客户端请求访问时间")
    @TableField("REQUEST_TIME_")
    private LocalDateTime requestTime;

    @ApiModelProperty(value = "请求携带的参数信息")
    @TableField("REQUEST_PARAMS_")
    private String requestParams;

    @ApiModelProperty(value = "返回的参数信息")
    @TableField("RESPONSE_RESULT_")
    private String responseResult;

    @ApiModelProperty(value = "接口响应时长（单位：ms）")
    @TableField("RESPONSE_TIME_LENGTH_")
    private Integer responseTimeLength;

    @ApiModelProperty(value = "请求访问状态（0：失败 1：成功）")
    @TableField("REQUEST_STATUS_")
    private Integer requestStatus;

    @ApiModelProperty(value = "失败错误内容描述")
    @TableField("ERROR_MSG_")
    private String errorMsg;
    @ApiModelProperty(value = "请求返回的数据量")
    @TableField("RESPONSE_NUM_")
    private Long responseNum;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_time_", fill= FieldFill.INSERT, select=true)
    private LocalDateTime createTime;
}
