package com.artfess.dataShare.dataApi.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataApi.model.BizServiceApi;
import com.artfess.base.manager.BaseManager;

import java.io.IOException;
import java.sql.SQLException;

/**
 * 数据资产-数据服务接口信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-11-22
 */
public interface BizServiceApiManager extends BaseManager<BizServiceApi> {

    /**
     * 注册接口
     * @param serviceApi
     * @return
     */
    boolean register(BizServiceApi serviceApi);

    /**
     * 发布接口
     * @param id
     * @return
     */
    boolean publish(String id);

    /**
     * 验证重复接口
     * @param url
     * @return
     */
    boolean checkApiValidity(BizServiceApi serviceApi);

    /**
     * 验证sql可用性
     * @param serviceApi
     * @return
     */
    boolean checkSqlValidity(BizServiceApi serviceApi) throws SQLException;

    /**
     * 删除接口配置
     * @param id
     * @return
     */
    boolean unregister(String id);


    /**
     * 下架接口
     * @param id
     * @return
     */
    boolean soldOut(String id);

    /**
     * 修改接口配置
     * @param serviceApi
     * @return
     */
    boolean updateServiceApi(BizServiceApi serviceApi);

    /**
     * 查询接口配置
     * @param queryFilter
     * @return
     */
    PageList<BizServiceApi> queryApi(QueryFilter<BizServiceApi> queryFilter);

    /**
     * 查看接口详情
     * @param id
     * @return
     */
    BizServiceApi getInfo(String id);

    /**
     * 浏览接口文档
     * @param id
     * @return
     */
    BizServiceApi viewApiDocument(String id) throws IOException;

    boolean checkApiCode(BizServiceApi serviceApi);
}
