package com.artfess.dataShare.algorithm.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmTaskinfo;

/**
 * 算法推理管理----算法推理信息管理表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
public interface BizAlgorithmTaskinfoManager extends BaseManager<BizAlgorithmTaskinfo> {

    /**
     * 算法推理信息管理表发布
     * @param id
     */
    void deploy(String id,String versionId,String routineName) throws Exception;

    /**
     * 修改算法推理状态信息
     * @param id
     */
    void updateDeployedStatus(String id,String deployedStatus) throws Exception;

    /**
     * 保存算法推理信息管理表
     * @param taskInfo
     */
    void saveTaskInfo(BizAlgorithmTaskinfo taskInfo) throws Exception;

    /**
     * 复制算法推理信息管理表
     */
    void saveAsTaskInfo(String id,String versionName,String versionCode) throws Exception;
}
