package com.artfess.dataShare.algorithm.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmCatalogsIndexManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmCatalogsIndex;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 算法推理管理-----特征指标管理表 （结果指标、问题指标、属性指标） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@RestController
@RequestMapping("/biz/algorithm/catalogsIndex/v1/")
@Api(tags = "算法推理管理-----特征指标管理表 ")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizAlgorithmCatalogsIndexController extends BaseController<BizAlgorithmCatalogsIndexManager, BizAlgorithmCatalogsIndex> {

    @PostMapping("/saveAlgorithmCatalogsIndex")
    @ApiOperation("保存特征指标管理的接口")
    public CommonResult<String> saveAlgorithmCatalogsIndex(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) BizAlgorithmCatalogsIndex t) throws Exception {
        baseService.saveAlgorithmCatalogsIndex(t);
        return new CommonResult<String>(true, "添加成功");
    }

    @PostMapping("/queryExistsByCode")
    @ApiOperation("查询特征指标编码是否存在")
    public CommonResult<String> queryBySysCodeCount(@ApiParam(name="code", value="编码") @RequestParam String code,
                                                           @ApiParam(name="id", value="id") @RequestParam String id) throws Exception {
        Integer count=baseService.queryBySysCodeCount(code,id);
        if(count>0){
            throw new ApplicationException("编码已经存在");
        }
        return new CommonResult<String>(true, "编码可以使用");
    }

    @RequestMapping(value = "updateFlag", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改启用禁用状态", httpMethod = "POST", notes = "批量修改启用禁用状态")
    public CommonResult<String> updateFlag(@ApiParam(name = "ids", value = "Id集合，以,隔开") @RequestParam String ids,
                                           @ApiParam(name = "flag", value = "有效标志（0：无效  1：有效）") @RequestParam Integer flag) throws Exception {
        baseService.updateFlag(ids, flag);
        return new CommonResult<>(true, "状态修改成功");
    }
}
