package com.artfess.dataShare.util;

import java.security.SecureRandom;
import java.util.Base64;

public class AKSKGenerator {

    private static final int ACCESS_KEY_BYTE_SIZE = 16;
    private static final int SECRET_KEY_BYTE_SIZE = 32;

    public static String generateAccessKey() {
        SecureRandom random = new SecureRandom();
        byte[] accessKeyBytes = new byte[ACCESS_KEY_BYTE_SIZE];
        random.nextBytes(accessKeyBytes);
        return Base64.getEncoder().encodeToString(accessKeyBytes).trim();
    }

    public static String generateSecretKey() {
        SecureRandom random = new SecureRandom();
        byte[] secretKeyBytes = new byte[SECRET_KEY_BYTE_SIZE];
        random.nextBytes(secretKeyBytes);
        return Base64.getEncoder().encodeToString(secretKeyBytes).trim();
    }

    public static boolean validateAKSK(String accessKey, String secretKey) {
        // 在实际应用中，你需要有对应的数据库或者认证服务来验证这两个Key是否有效
        // 这里仅为示例，简单地检查两个Key是否为非空和相同长度
        return accessKey != null && secretKey != null && accessKey.length() > 0 && secretKey.length() > 0;
    }

    public static void main(String[] args) {
        String accessKey = generateAccessKey();
        String secretKey = generateSecretKey();

        System.out.println("Access Key: " + accessKey);
        System.out.println("Secret Key: " + secretKey);

        boolean isValid = validateAKSK(accessKey, secretKey);
        System.out.println("AKSK is valid: " + isValid);
    }
}