package com.artfess.dataShare.scheduler.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 定时任务  ---  执行日志表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-16
 */
@ApiModel(value="BizSchedulerJobLog对象", description="定时任务  ---  执行日志表")
@TableName("BIZ_SCHEDULER_JOB_LOG")
public class BizSchedulerJobLog extends BaseModel<BizSchedulerJobLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "作业ID")
    @TableField("JOB_ID_")
    private String jobId;

    @ApiModelProperty(value = "作业名称")
    @TableField("JOB_NAME_")
    private String jobName;

    @ApiModelProperty(value = "作业_执行开始时间")
    @TableField("JOB_START_TIME_")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime jobStartTime;

    @ApiModelProperty(value = "作业_执行结束时间")
    @TableField("JOB_END_TIME_")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime jobEndTime;

    @ApiModelProperty(value = "作业_执行时长（单位：秒）")
    @TableField("JOB_DURATION_")
    private Integer jobDuration;

    @ApiModelProperty(value = "作业执行状态（0：失败 1：成功）")
    @TableField("JOB_STATUS_")
    private Integer jobStatus;

    @ApiModelProperty(value = "任务类型（1Jave 2Kettle 3Shell 4平台ETL 5Spark）")
    @TableField("TASK_MODE_")
    private Integer taskMode;

    @ApiModelProperty(value = "作业任务类型（1采集任务 2共享任务 3明细任务 4应用任务）")
    @TableField("TASK_TYPE_")
    private Integer taskType;

    @ApiModelProperty(value = "调度任务_ID")
    @TableField("TASK_ID_")
    private String taskId;

    @ApiModelProperty(value = "调度任务_开始时间")
    @TableField("TASK_START_TIME_")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime taskStartTime;

    @ApiModelProperty(value = "调度任务_结束时间")
    @TableField("TASK_END_TIME_")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime taskEndTime;

    @ApiModelProperty(value = "调度任务执行时长（单位：秒）")
    @TableField("TASK_DURATION_")
    private Integer taskDuration;

    @ApiModelProperty(value = "调度任务_执行任务参数")
    @TableField("TASK_PARAM_")
    private String taskParam;

    @ApiModelProperty(value = "调度任务_状态（0:失败 1：成功）")
    @TableField("TASK_STATUS_")
    private Integer taskStatus;

    @ApiModelProperty(value = "日志记录时间")
    @TableField("LOG_TIME_")
    private LocalDateTime logTime;

    @ApiModelProperty(value = "全日志详情")
    @TableField("LOG_DETAIL_")
    private String logDetail;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public LocalDateTime getJobStartTime() {
        return jobStartTime;
    }

    public void setJobStartTime(LocalDateTime jobStartTime) {
        this.jobStartTime = jobStartTime;
    }

    public LocalDateTime getJobEndTime() {
        return jobEndTime;
    }

    public void setJobEndTime(LocalDateTime jobEndTime) {
        this.jobEndTime = jobEndTime;
    }

    public Integer getJobDuration() {
        return jobDuration;
    }

    public void setJobDuration(Integer jobDuration) {
        this.jobDuration = jobDuration;
    }

    public Integer getJobStatus() {
        return jobStatus;
    }

    public void setJobStatus(Integer jobStatus) {
        this.jobStatus = jobStatus;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public Integer getTaskMode() {
        return taskMode;
    }

    public void setTaskMode(Integer taskMode) {
        this.taskMode = taskMode;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public LocalDateTime getTaskStartTime() {
        return taskStartTime;
    }

    public void setTaskStartTime(LocalDateTime taskStartTime) {
        this.taskStartTime = taskStartTime;
    }

    public LocalDateTime getTaskEndTime() {
        return taskEndTime;
    }

    public void setTaskEndTime(LocalDateTime taskEndTime) {
        this.taskEndTime = taskEndTime;
    }

    public Integer getTaskDuration() {
        return taskDuration;
    }

    public void setTaskDuration(Integer taskDuration) {
        this.taskDuration = taskDuration;
    }

    public String getTaskParam() {
        return taskParam;
    }

    public void setTaskParam(String taskParam) {
        this.taskParam = taskParam;
    }

    public Integer getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public LocalDateTime getLogTime() {
        return logTime;
    }

    public void setLogTime(LocalDateTime logTime) {
        this.logTime = logTime;
    }

    public String getLogDetail() {
        return logDetail;
    }

    public void setLogDetail(String logDetail) {
        this.logDetail = logDetail;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSchedulerJobLog{" +
            "id=" + id +
            ", jobId=" + jobId +
            ", jobName=" + jobName +
            ", jobStartTime=" + jobStartTime +
            ", jobEndTime=" + jobEndTime +
            ", jobDuration=" + jobDuration +
            ", jobStatus=" + jobStatus +
            ", taskMode=" + taskMode +
            ", taskId=" + taskId +
            ", taskStartTime=" + taskStartTime +
            ", taskEndTime=" + taskEndTime +
            ", taskDuration=" + taskDuration +
            ", taskParam=" + taskParam +
            ", taskStatus=" + taskStatus +
            ", logTime=" + logTime +
            ", logDetail=" + logDetail +
        "}";
    }
}
