package com.artfess.dataShare.scheduler.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.scheduler.model.BizSchedulerJob;
import com.artfess.base.manager.BaseManager;
import org.quartz.SchedulerException;
import org.springframework.web.multipart.MultipartFile;

/**
 * 定时任务作业  ---  配置表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-16
 */
public interface BizSchedulerJobManager extends BaseManager<BizSchedulerJob> {


    /**
     * 分页查询
     * @param queryFilter
     * @return
     */
    PageList<BizSchedulerJob> sliceQuery(QueryFilter<BizSchedulerJob> queryFilter);

    /**
     * 添加定时任务作业 配置
     * @param schedulerJob
     * @param multipartFiles 附件信息
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/12/16 19:11
     */
    boolean insertSchedulerJob(BizSchedulerJob schedulerJob, MultipartFile[] multipartFiles);

    /**
     * 修改数据抽取任务
     * @param schedulerJob
     * @param multipartFiles 附件信息
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/12/16 19:12
     */
    boolean updateSchedulerJob(BizSchedulerJob schedulerJob, MultipartFile[] multipartFiles);

    /**
     * 根据ID删除数据抽取任务
     * @param id
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/12/16 19:12
     */
    boolean deleteSchedulerJobById(String id);

    /**
     * 根据ID查询数据抽取任务
     * @param id
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/12/16 19:12
     */
    BizSchedulerJob getSchedulerJobById(String id);

    /**
     * @Description: 启动数据抽取任务
     * @param jobId  作业任务ID
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/11/12 16:43
     */
    boolean startUpJob(String jobId);

    /**
     * @Description: 停止数据抽取任务
     * @param jobId  作业任务ID
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/11/12 16:43
     */
    boolean stopJob(String jobId);

    /**
     * @Description: 删除数据抽取任务
     * @param jobId  作业任务ID
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/11/12 16:43
     */
    boolean delJob(String jobId);


    /**
     * @Description: 执行一次作业任务
     * @param jobId  作业任务ID
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/11/12 16:43
     */
    boolean executeJob(String jobId);

    /**
     * @Description: 验证类
     * @param className  类路径
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/11/12 16:43
     */
    boolean validClass(String className);

}
