package com.artfess.dataShare.role.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.role.vo.CatalogsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.role.model.BizRoleCatalogs;
import com.artfess.dataShare.role.manager.BizRoleCatalogsManager;

import javax.annotation.Resource;
import java.util.List;

/**
 * 角色数据目录授权表（角色关联人员的目录分类） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-12-25
 */
@RestController
@RequestMapping("/biz/dataShare/role/v1/")
@Api(tags = "角色数据目录授权")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizRoleCatalogsController extends BaseController<BizRoleCatalogsManager, BizRoleCatalogs> {
    @Resource
    BizRoleCatalogsManager roleCatalogsManager;

    @ApiOperation("查询登录人有权限的数据目录ID")
    @PostMapping("queryDwCatalogsId")
    public CommonResult queryDwCatalogsId(String dataType) throws Exception {
        List<CatalogsVo> list=this.roleCatalogsManager.queryDwCatalogsId(dataType);
        return CommonResult.success(list,"查询成功");
    }

    @ApiOperation("根据角色Id查询授权的目录")
    @PostMapping("queryDwCatalogByRoleId")
    public CommonResult queryDwCatalogByRoleId(String roleId) throws Exception {
        List<CatalogsVo> list=this.roleCatalogsManager.queryDwCatalogByRoleId(roleId);
        return CommonResult.success(list,"查询成功");
    }
}
