package com.artfess.dataShare.dataShare.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.dataShare.dataShare.dto.ApiAuthDto;
import com.artfess.dataShare.dataShare.dto.FilesAuthDto;
import com.artfess.dataShare.dataShare.dto.TableAuthDto;
import com.artfess.dataShare.dataShare.manager.*;
import com.artfess.dataShare.dataShare.model.*;
import com.artfess.dataShare.dataShare.dao.BizShareAuthDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.dataShare.dataShare.vo.ConsumerAuthVo;
import com.artfess.dataShare.util.MySQLUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 数据资产--共享资源授权 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-30
 */
@Service
public class BizShareAuthManagerImpl extends BaseManagerImpl<BizShareAuthDao, BizShareAuth> implements BizShareAuthManager {

    @Resource
    private BizShareTableManager tableManager;

    @Resource
    private BizShareConsumerManager consumerManager;

    @Resource
    private BizShareFilesManager filesManager;

    @Resource
    private BizShareApiManager apiManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean auth(List<BizShareAuth> list) throws Exception {
        for (BizShareAuth auth : list) {
            if (save(auth)){
                if ("1".equals(auth.getResourceType())){
                    BizShareConsumer consumer = consumerManager.get(auth.getMemberId());
                    if (!"1".equals(consumer.getIsOpenDb())){
                        throw new ApplicationException("【" + consumer.getName() + "】没有开通库表共享!");
                    }
                    auth.setResourceId(null);
                    String tableId = auth.getTableId();
                    BizShareTable table = tableManager.get(tableId);
                    String dbAlias = table.getDbAlias();
                    String tableCode = table.getTableCode();
                    JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(dbAlias);
                    MySQLUtils.createGrant(jdbcTemplate,"SELECT",consumer.getDataBaseName(),tableCode,consumer.getDatabaseUser());
                }
            }
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean revokeAuth(List<String> ids) throws Exception {
        for (String id : ids) {
            BizShareAuth auth = get(id);
            if ("1".equals(auth.getResourceType())){
                BizShareConsumer consumer = consumerManager.get(auth.getMemberId());
                String tableId = auth.getTableId();
                BizShareTable table = tableManager.get(tableId);
                String dbAlias = table.getDbAlias();
                String tableCode = table.getTableCode();
                JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(dbAlias);
                MySQLUtils.revokeGrant(jdbcTemplate,"SELECT",consumer.getDataBaseName(),tableCode,consumer.getDatabaseUser());
            }
            removeById(id);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean tableAuth(List<BizShareAuth> list) throws Exception {
        for (BizShareAuth auth : list) {
            if (save(auth)){
                BizShareConsumer consumer = consumerManager.get(auth.getMemberId());
                if (!"1".equals(consumer.getIsOpenDb())){
                    throw new ApplicationException("【" + consumer.getName() + "】没有开通库表共享!");
                }
                String tableId = auth.getTableId();
                BizShareTable table = tableManager.get(tableId);
                String dbAlias = table.getDbAlias();
                String tableCode = table.getTableCode();
                JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(dbAlias);
                MySQLUtils.createGrant(jdbcTemplate,"SELECT",consumer.getDataBaseName(),tableCode,consumer.getDatabaseUser());
            }
        }
        return true;
    }

    @Override
    public PageList<ConsumerAuthVo> queryPageByConsumer(QueryFilter<BizShareAuth> queryFilter, String consumerId, String resourceType) {
        IPage<BizShareAuth> iPage = baseMapper.queryPageByConsumer(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()), consumerId, resourceType);
        PageList<BizShareAuth> pageList = new PageList<>(iPage);
        PageList<ConsumerAuthVo> pageVo = new PageList<>();
        pageVo.setPage(pageList.getPage());
        pageVo.setPageSize(pageList.getPageSize());
        pageVo.setTotal(pageList.getTotal());
        List<ConsumerAuthVo> authVoList = new ArrayList<>();

        List<BizShareAuth> authList = pageList.getRows();
        for (BizShareAuth auth : authList) {
            ConsumerAuthVo consumerAuthVo = new ConsumerAuthVo();
            consumerAuthVo.setAuthId(auth.getId());
            BizShareTable table = tableManager.get(auth.getTableId());
            consumerAuthVo.setTable(table);
            String resourceId = auth.getResourceId();
            //查询离线文件
            if ("2".equals(resourceType)){
                BizShareFiles files = filesManager.get(resourceId);
                consumerAuthVo.setFiles(files);
            }
            //查询接口
            if ("3".equals(resourceType)){
                BizShareApi api = apiManager.get(resourceId);
                consumerAuthVo.setApi(api);
            }
            authVoList.add(consumerAuthVo);
        }
        pageVo.setRows(authVoList);
        return pageVo;
    }

    @Override
    public PageList<ConsumerAuthVo> queryPageByResource(QueryFilter<BizShareAuth> queryFilter, String resourceId, String resourceType) {
        IPage<BizShareAuth> iPage = baseMapper.queryPageByResource(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()),resourceId,resourceType);
        PageList<BizShareAuth> pageList = new PageList<>(iPage);
        PageList<ConsumerAuthVo> pageVo = new PageList<>();
        pageVo.setPage(pageList.getPage());
        pageVo.setPageSize(pageList.getPageSize());
        pageVo.setTotal(pageList.getTotal());
        List<ConsumerAuthVo> authVoList = new ArrayList<>();

        List<BizShareAuth> authList = pageList.getRows();
        for (BizShareAuth auth : authList) {
            ConsumerAuthVo consumerAuthVo = new ConsumerAuthVo();
            consumerAuthVo.setAuthId(auth.getId());
            BizShareConsumer consumer = consumerManager.get(auth.getMemberId());
            consumerAuthVo.setConsumer(consumer);
            authVoList.add(consumerAuthVo);
        }
        pageVo.setRows(authVoList);
        return pageVo;
    }

    @Override
    public PageList<TableAuthDto> queryTableAuth(QueryFilter<BizShareAuth> queryFilter, String consumerId) {
        IPage<BizShareAuth> iPage = baseMapper.queryTableAuth(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter,currentModelClass()),
                consumerId);
        PageList<BizShareAuth> pageList = new PageList<>(iPage);
        List<TableAuthDto> resultList = new ArrayList<>();
        List<BizShareAuth> rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            TableAuthDto tableAuthDto = new TableAuthDto();
            BizShareTable table = tableManager.get(auth.getTableId());
            tableAuthDto.setAuthId(auth.getId());
            tableAuthDto.setTableId(table.getId());
            tableAuthDto.setTableName(table.getName());
            tableAuthDto.setTableCode(table.getTableCode());
            tableAuthDto.setTableDescription(table.getDescription());
            resultList.add(tableAuthDto);
        }
        PageList<TableAuthDto> result = new PageList<>();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }

    @Override
    public PageList<ApiAuthDto> queryApiAuth(QueryFilter<BizShareAuth> queryFilter, String consumerId) {
        IPage<BizShareAuth> iPage = baseMapper.queryApiAuth(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter,currentModelClass()),
                consumerId);
        PageList<BizShareAuth> pageList = new PageList<>(iPage);
        List<ApiAuthDto> resultList = new ArrayList<>();
        List<BizShareAuth> rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            ApiAuthDto apiAuthDto = new ApiAuthDto();
            BizShareTable table = tableManager.get(auth.getTableId());
            BizShareApi api = apiManager.get(auth.getResourceId());
            apiAuthDto.setAuthId(auth.getId());
            apiAuthDto.setTableId(table.getId());
            apiAuthDto.setTableName(table.getName());
            apiAuthDto.setTableCode(table.getTableCode());
            apiAuthDto.setTableDescription(table.getDescription());
            apiAuthDto.setApiName(api.getApiName());
            apiAuthDto.setApiUrl(api.getApiUrl());
            apiAuthDto.setApiMode(api.getApiMode());
            resultList.add(apiAuthDto);
        }
        PageList<ApiAuthDto> result = new PageList<>();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }

    @Override
    public PageList<FilesAuthDto> queryFilesAuth(QueryFilter<BizShareAuth> queryFilter, String consumerId) {
        IPage<BizShareAuth> iPage = baseMapper.queryFilesAuth(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter,currentModelClass()),
                consumerId);
        PageList<BizShareAuth> pageList = new PageList<>(iPage);
        List<FilesAuthDto> resultList = new ArrayList<>();
        List<BizShareAuth> rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            FilesAuthDto filesAuthDto = new FilesAuthDto();
            BizShareTable table = tableManager.get(auth.getTableId());
            BizShareFiles files = filesManager.get(auth.getResourceId());
            filesAuthDto.setAuthId(auth.getId());
            filesAuthDto.setTableId(table.getId());
            filesAuthDto.setTableName(table.getName());
            filesAuthDto.setTableCode(table.getTableCode());
            filesAuthDto.setTableDescription(table.getDescription());
            filesAuthDto.setFileName(files.getFileName());
            filesAuthDto.setFileContent(files.getFileContent());
            resultList.add(filesAuthDto);
        }
        PageList<FilesAuthDto> result = new PageList<>();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }
}
