package com.artfess.dataShare.dataShare.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.dataShare.dataApi.model.BizServiceCatalogs;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataShare.model.BizShareCatalogs;
import com.artfess.dataShare.dataShare.manager.BizShareCatalogsManager;

import java.util.List;

/**
 * 数据资产-共享资源目录 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-03
 */
@RestController
@RequestMapping("/biz/dataShare/shareCatalogs/v1/")
@Api(tags = "数据资产-共享资源目录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizShareCatalogsController extends BaseController<BizShareCatalogsManager, BizShareCatalogs> {

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息")
                                       @RequestBody
                                       @Validated({AddGroup.class}) BizShareCatalogs shareCatalogs){
        shareCatalogs.setIsDele("0");
//        String id = this.baseService.insertTree(shareCatalogs);
        String id = this.baseService.saveTree(shareCatalogs);
        if(id == null){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
        }
        return CommonResult.success(id,"添加成功");
    }

    @GetMapping("/getTree")
    @ApiOperation("获取树形目录")
    public CommonResult<List<BizShareCatalogs>> getTree(){
        List<BizShareCatalogs> baseServiceList = this.baseService.getAll();
        List<BizShareCatalogs> shareCatalogs = BeanUtils.listToTree(baseServiceList);
        return CommonResult.success(shareCatalogs,"查询成功");
    }

    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息")
                                           @Validated({UpdateGroup.class})
                                           @RequestBody BizShareCatalogs shareCatalogs) {
        String id = baseService.upTree(shareCatalogs);
        if(id == null){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
        }
        return CommonResult.success(id,"修改成功");
    }

    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        boolean result = baseService.deleteById(id);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/removeTree")
    @ApiOperation("移动树")
    public CommonResult<String> removeTree(@RequestParam("id") String id,@RequestParam("parentId") String parentId){
        boolean result = baseService.removeTree(id,parentId);
        return result ? CommonResult.success(null,"操作成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,"操作失败");
    }
}
