package com.artfess.dataShare.dataResource.app.model;

import com.artfess.base.entity.AutoOrgFillModel;
import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.model.Tree;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据应用层表-APP层资源目录分类表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-18
 */
@ApiModel(value="BizAppCatalogs对象", description="数据应用层表-APP层资源目录分类表")
@TableName("BIZ_APP_CATALOGS")
public class BizAppCatalogs extends BaseTreeModel<BizAppCatalogs> implements Tree {

    private static final long serialVersionUID = 1L;
    /*@ApiModelProperty(value = "目录名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "目录编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "父级目录ID")
    @TableField("PARENT_ID_")
    private String parentId;

    @ApiModelProperty(value = "ID路径")
    @TableField("FULL_ID_")
    private String fullId;

    @ApiModelProperty(value = "名称路径")
    @TableField("FULL_NAME_")
    private String fullName;

    @ApiModelProperty(value = "子节点个数")
    @TableField("HAS_CHILDREN_")
    private Integer hasChildren;*/

    @ApiModelProperty(value = "创建人", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value = "CREATE_BY_", fill=FieldFill.INSERT, select=true)
    private String createBy;

    @ApiModelProperty(value = "创建单位", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value = "CREATE_ORG_ID_", fill=FieldFill.INSERT, select=true)
    private String createOrgId;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value = "CREATE_TIME_", fill=FieldFill.INSERT, select=true)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人员", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value = "UPDATE_BY_", fill=FieldFill.UPDATE, select=false)
    private String updateBy;

    @ApiModelProperty(value = "修改单位")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "修改时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value = "UPDATE_TIME_", fill=FieldFill.UPDATE, select=false)
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    @TableLogic
    private String isDele;


    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @TableField(exist=false)
    protected List<Tree> children = Lists.newArrayList();

    @Override
    public String getText() {
        return name;
    }

    @Override
    public List<Tree> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List<Tree> list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {

    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getFullId() {
        return fullId;
    }

    public void setFullId(String fullId) {
        this.fullId = fullId;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Integer getHasChildren() {
        return hasChildren;
    }

    public void setHasChildren(Integer hasChildren) {
        this.hasChildren = hasChildren;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAppCatalogs{" +
                ", name=" + name +
                ", code=" + code +
                ", parentId=" + parentId +
                ", fullId=" + fullId +
                ", fullName=" + fullName +
                ", hasChildren=" + hasChildren +
                ", sn=" + sn +
                ", isDele=" + isDele +
                ", createBy=" + createBy +
                ", createOrgId=" + createOrgId +
                ", createTime=" + createTime +
                ", updateBy=" + updateBy +
                ", updateOrgId=" + updateOrgId +
                ", updateTime=" + updateTime +
                ", tenantId=" + tenantId +
        "}";
    }
}
