package com.artfess.dataShare.algorithm.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmReasonManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmReason;
import com.artfess.dataShare.algorithm.vo.TaskReasonVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.List;

/**
 * 算法推理管理----逻辑推理编排表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@RestController
@RequestMapping("/biz/algorithm/reason/v1/")
@Api(tags = "算法推理管理----逻辑推理编排")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizAlgorithmReasonController extends BaseController<BizAlgorithmReasonManager, BizAlgorithmReason> {

    @PostMapping("/saveReason")
    @ApiOperation("逻辑推理编排")
    public CommonResult<String> deployReason(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) BizAlgorithmReason t) throws Exception {
        baseService.saveReason(t);
        return new CommonResult<String>(true, "添加成功");
    }

    @PostMapping("/queryTaskAndReason")
    @ApiOperation("根据指标ID查询使用了这个指标的任务、指标逻辑关系表和下级-关联查询")
    public List<TaskReasonVo> queryTaskAndReason(@ApiParam(name="indexId", value="指标ID") @RequestParam String indexId,
                                                 @ApiParam(name="type", value="推理类型（1：一推多 2：多推一）") @RequestParam String type) throws Exception {
        return baseService.queryTaskAndReason(indexId,type);
    }

    @PostMapping("/exportTaskAndReason")
    @ApiOperation("指标推理表格查询和导出说明")
    public void exportTaskAndReason(HttpServletResponse response, @ApiParam(name="indexId", value="指标ID") @RequestParam String indexId,
                                    @ApiParam(name="type", value="推理类型（1：一推多 2：多推一）") @RequestParam String type) throws Exception {
        String filePath = baseService.exportTaskAndReason(indexId,type);
        File file = new File(filePath);
        //System.out.println(filePath);
        HttpUtil.downLoadFile(response, filePath, file.getName());
    }

    @PostMapping("/queryReason")
    @ApiOperation("只传任务ID就查询最新版本的编排，传了版本就查询对应的版本")
    public List<BizAlgorithmReason> queryReason(@ApiParam(name="taskId", value="任务ID") @RequestParam String taskId,
                                                 @ApiParam(name="versionId", value="版本ID") @RequestParam String versionId) throws Exception {
        return baseService.queryReason(taskId,versionId);
    }

}
