package com.artfess.sysConfig.persistence.manager;

import com.artfess.base.manager.BaseManager;

import com.artfess.sysConfig.persistence.model.SysDictionary;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.sysConfig.vo.DictionaryDetailVo;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 系统字典
 */
public interface SysDictionaryManager extends BaseManager<SysDictionary> {

    /**
     * @Description: 保存字典
     * @Param: sysDictionary
     * @Return: java.lang.String
     * @Author: ZQF
     * @Date: 2021/3/5
     */
    String saveDictionary(SysDictionary sysDictionary) throws Exception;

    /**
     * @Description: 批量删除字典信息
     * @Param: ids
     * @Return: void
     * @Author: ZQF
     * @Date: 2021/3/5
     */
    void deleteDictionaries(String ids) throws Exception;;

    /**
     * @Description: 修改字典状态
     * @Param: ids
     * @Param: status
     * @Return: void
     * @Author: ZQF
     * @Date: 2021/3/17
     */
    void updateDictionariesStatus(String ids, Integer status);

    /**
     * 导入字典项
     * @return
     */
    void importDic(MultipartFile file) throws Exception;

    /**
     * 根据ID查询字典
     * @param id  字典id
     * @return
     */
    SysDictionary loadDictionaryById(String id);

    /**
     * @Description: 移动字典
     * @Param: ids
     * @Param: treeId
     * @Return: void
     * @Author: ZQF
     * @Date: 2021/3/17
     */
    void moveDictionaries(String ids, String treeId);

    /**
     * @Description: 修改字典排序号
     * @Param: map
     * @Return: void
     * @Author: ZQF
     * @Date: 2021/3/17
     */
    void updateDictionariesSequence(HashMap<String, Integer> map);

    /**
     * @Description: 更新字典缓存
     * @Return: void
     * @Author: ZQF
     * @Date: 2021/3/17
     */
    void syncDictionaryRedis() throws IOException;

    /**
     * @Description: 根据字典值的id级联查询下级字典
     * @Param: detailId
     * @Return: java.util.List<com.artfess.portal.model.SysDictionary>
     * @Author: ZQF
     * @Date: 2021/3/17
     */
    List<SysDictionary> queryLowerDictionary(String detailId);

    /**
     * @Description: 查询所有字典信息（登陆时缓存到前台）
     * @Return: java.util.Map<java.lang.String, java.util.List < com.artfess.portal.params.DictionaryDetailVo>>
     * @Author: ZQF
     * @Date: 2021/3/17
     */
    Map<String, List<DictionaryDetailVo>> queryAllDictItems() throws IOException;

    /**
     * @Description: 根据codes查询字典信息
     * @Param: codes
     * @Return: java.util.Map<java.lang.String, java.util.List < com.artfess.portal.model.SysDictionaryDetail>>
     * @Author: ZQF
     * @Date: 2021/3/17
     */
    Map<String, List<SysDictionaryDetail>> queryDictItemsByCode(String codes) throws IOException;

    /**
    * @Description: 通过字典code获取字典数据
    * @Param: code
    * @Param: key
    * @Param: kindId
    * @Return: java.lang.String
    * @Author: ZQF
    * @Date: 2021/3/17
    */
    String queryDictTextByKey(String code, String key, int kindId);

    /**
    * @Description: 通过查询指定code 获取字典
    * @Param: code
    * @Param: companyId  
    * @Return: java.util.List<com.artfess.portal.params.DictModel>
    * @Author: ZQF 
    * @Date: 2021/3/17 
    */
    List<DictModel> queryDictListItemsByCode(String code);

    /**
    * @Description: 通过上级字典项的值与其下级级联字典的id，获取级联的字典项数据
    * @Param: dictLowerId
    * @Param: detailId
    * @Return: java.util.List<com.artfess.portal.model.SysDictionaryDetail>
    * @Author: ZQF
    * @Date: 2021/3/17
    */
    List<SysDictionaryDetail> queryLowerDictionaryDetail(String dictLowerId, String detailId);

}
