/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.util;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ThreadMessageUtil
implements ContextThread {
    private static ThreadLocal<Map<String, String>> localMapMsg = new ThreadLocal();

    public static void addMapMsg(String key, String msg) {
        Map<String, String> map = localMapMsg.get();
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, String>();
        }
        map.put(key, msg);
        localMapMsg.set(map);
    }

    public static String getMapMsg(String key) {
        Map<String, String> map = localMapMsg.get();
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static Map<String, String> getMapMsg(boolean clean) {
        Map<String, String> map = localMapMsg.get();
        if (clean) {
            localMapMsg.remove();
        }
        return map;
    }

    public static String getMapMsg(String key, boolean clean) {
        Map<String, String> map = localMapMsg.get();
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (map.containsKey(key)) {
            String msg = map.get(key);
            if (clean) {
                map.remove(key);
            }
            return msg;
        }
        return null;
    }

    public static void cleanMapMsg() {
        localMapMsg.remove();
    }

    public void cleanAll() {
        ThreadMessageUtil.cleanMapMsg();
    }
}

