/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.task.service;

import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.FormFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.AopType;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.DoNextEvent;
import com.artfess.bpm.api.event.DoNextModel;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.model.process.task.BpmTaskTurn;
import com.artfess.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.artfess.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.artfess.bpm.api.plugin.core.runtime.TaskActionHandler;
import com.artfess.bpm.api.plugin.core.session.TaskActionPluginSession;
import com.artfess.bpm.api.plugin.core.task.TaskActionHandlerConfig;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmTaskActionService;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.listener.BusDataUtil;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskCandidateManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskTurnManager;
import com.artfess.bpm.persistence.manager.TaskTurnAssignManager;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.model.DefaultBpmTaskTurn;
import com.artfess.bpm.persistence.model.TaskTurnAssign;
import com.artfess.bpm.persistence.util.BpmStackRelationUtil;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.bpm.util.PortalDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmTaskActionService
implements BpmTaskActionService {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmPluginSessionFactory bpmPluginSessionFactory;
    @Resource
    TaskActionHandlerConfig taskActionHandlerConfig;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    TaskTurnAssignManager taskTurnAssignManager;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;

    @Override
    public boolean finishTask(TaskFinishCmd taskCmd) throws Exception {
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)taskCmd;
        ContextThreadUtil.setActionCmd(cmd);
        BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
        Map<String, Object> cmdVariables = taskCmd.getVariables();
        if (BeanUtils.isEmpty(cmdVariables)) {
            cmdVariables = this.natTaskService.getVariables(bpmTask.getTaskId());
        }
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), bpmTask.getNodeId());
        if (BpmCheckOpinionUtil.effectNodeTransActions.contains(taskCmd.getActionName()) && NodeType.USERTASK.equals((Object)bpmNodeDef.getType())) {
            BaseContext context = (BaseContext)AppUtil.getBean(BaseContext.class);
            cmdVariables.put("nodeAuditor_" + bpmTask.getNodeId(), context.getCurrentUserAccout());
        }
        taskCmd.setVariables(cmdVariables);
        BpmDelegateTask task = null;
        if (StringUtil.isNotZeroEmpty((String)bpmTask.getTaskId())) {
            task = this.natTaskService.getByTaskId(bpmTask.getTaskId());
        }
        DoNextModel donextModel = new DoNextModel(cmd, AopType.PREVIOUS);
        DoNextEvent donextEv = new DoNextEvent(donextModel);
        AppUtil.publishEvent((ApplicationEvent)donextEv);
        TaskActionPluginSession taskActionPluginSession = this.bpmPluginSessionFactory.buildTaskActionPluginSession(task, taskCmd);
        String actionName = "";
        actionName = StringUtil.isNotEmpty((String)taskCmd.getAddSignAction()) ? taskCmd.getAddSignAction() : taskCmd.getActionName();
        TaskActionHandler handler = this.taskActionHandlerConfig.getTaskActionHandler(actionName);
        TaskActionHandlerDef def = this.taskActionHandlerConfig.getTaskActionHandlerDef(taskCmd.getActionName());
        boolean result = (Boolean)handler.execute(taskActionPluginSession, def);
        if (StringUtil.isNotEmpty((String)taskCmd.getAddSignTaskId())) {
            DefaultBpmCheckOpinion defaultBpmCheckOpinion = this.bpmCheckOpinionManager.getByTaskId(taskCmd.getAddSignTaskId());
            defaultBpmCheckOpinion.setStatus(OpinionStatus.REJECT.getKey());
            defaultBpmCheckOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
            defaultBpmCheckOpinion.setOpinion(((DefaultTaskFinishCmd)taskCmd).getApprovalOpinion());
            defaultBpmCheckOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
            defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
            this.bpmCheckOpinionManager.update((Model)defaultBpmCheckOpinion);
        }
        DoNextModel donextAfterModel = new DoNextModel(cmd, AopType.POST);
        DoNextEvent donextAfterEv = new DoNextEvent(donextAfterModel);
        AppUtil.publishEvent((ApplicationEvent)donextAfterEv);
        ActionCmd finsActionCmd = ContextThreadUtil.getActionCmd();
        Object rejectAfterExecutionId = finsActionCmd.getTransitVars("rejectAfterExecutionId");
        if (BeanUtils.isNotEmpty((Object)rejectAfterExecutionId)) {
            BpmStackRelationUtil.multipleInstancesRejectAdjust(rejectAfterExecutionId.toString());
        } else {
            Object rejectSingleExecutionId = finsActionCmd.getTransitVars("rejectSingleExecutionId");
            if (BeanUtils.isNotEmpty((Object)rejectSingleExecutionId)) {
                BpmStackRelationUtil.singleInstancesRejectAdjust(rejectSingleExecutionId.toString());
            }
        }
        Object rejectDirectExecutionId = finsActionCmd.getTransitVars("rejectDirectExecutionId");
        if (BeanUtils.isNotEmpty((Object)rejectDirectExecutionId)) {
            BpmStackRelationUtil.instancesRejectDirectAdjust(rejectDirectExecutionId.toString());
        }
        return result;
    }

    @Override
    public void create(BpmDelegateTask delegateTask) throws Exception {
        BpmTask task = BpmUtil.convertTask(delegateTask);
        this.bpmTaskManager.create((Model)((DefaultBpmTask)task));
    }

    @Override
    public void remove(String taskId) {
        this.bpmTaskManager.delByRelateTaskId(taskId);
    }

    @Override
    public void delegate(String taskId, String toUser, String notifyType, String opinion, String files, String formData) throws Exception {
        BpmTask bpmTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        BpmTaskTurn bpmTaskTurn = this.bpmTaskTurnManager.getByTaskId(taskId);
        IUser user = this.userServiceImpl.getUserById(toUser);
        this.bpmTaskManager.delegate(taskId, user);
        ArrayList<IUser> userList = new ArrayList<IUser>();
        userList.add(user);
        if (bpmTaskTurn == null) {
            this.bpmTaskTurnManager.add((DefaultBpmTask)bpmTask, ContextUtil.getCurrentUser(), user, opinion, "turn");
        } else {
            if (bpmTaskTurn.getAssigneeId().equals(toUser)) {
                throw new RuntimeException("\u4efb\u52a1\u5df2\u4ea4\u7531\u3010" + bpmTaskTurn.getAssigneeName() + "\u3011\u5904\u7406\uff01");
            }
            List<TaskTurnAssign> turnAssign = this.bpmTaskTurnManager.getTurnAssignByTaskTurnId(bpmTaskTurn.getId());
            for (TaskTurnAssign taskTurnAssign : turnAssign) {
                if (!toUser.equals(taskTurnAssign.getReceiverId()) && !toUser.equals(taskTurnAssign.getFromUserId())) continue;
                throw new RuntimeException("\u3010" + user.getFullname() + "\u3011\u5df2\u7ecf\u8f6c\u529e\u8fc7,\u4e0d\u80fd\u91cd\u590d\u8f6c\u529e,\u8bf7\u8054\u7cfb\u8be5\u7528\u6237\u53d6\u56de\uff01");
            }
            DefaultBpmTaskTurn turn = (DefaultBpmTaskTurn)bpmTaskTurn;
            turn.setStatus("running");
            turn.setAssigneeId(user.getUserId());
            turn.setAssigneeName(user.getFullname());
            this.bpmTaskTurnManager.update((Model)turn);
            this.bpmTaskTurnManager.addTurnAssign(turn.getId(), user, opinion);
        }
        DefaultBpmCheckOpinion delegeteCheckOpinion = this.bpmCheckOpinionManager.getByTaskIdStatus(taskId, OpinionStatus.AWAITING_CHECK.getKey());
        delegeteCheckOpinion.setId(UniqueIdUtil.getSuid());
        delegeteCheckOpinion.setStatus(OpinionStatus.DELIVERTO.getKey());
        delegeteCheckOpinion.setCompleteTime(LocalDateTime.now());
        delegeteCheckOpinion.setAuditor(ContextUtil.getCurrentUserId());
        delegeteCheckOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
        delegeteCheckOpinion.setOpinion(StringUtil.isEmpty((String)opinion) ? "\u4efb\u52a1\u8f6c\u529e" : opinion);
        long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)delegeteCheckOpinion.getCreateTime());
        delegeteCheckOpinion.setDurMs(durMs);
        delegeteCheckOpinion.setQualfieds("");
        delegeteCheckOpinion.setFiles(files);
        delegeteCheckOpinion.setQualfiedNames(user.getFullname());
        this.bpmCheckOpinionManager.create((Model)delegeteCheckOpinion);
        ThreadMsgUtil.addMapMsg((String)"leaderId", (String)"");
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(taskId);
        if (BeanUtils.isNotEmpty((Object)checkOpinion)) {
            checkOpinion.setCreateTime(LocalDateTime.now());
            ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setType("user");
            bpmIdentity.setId(user.getUserId());
            bpmIdentity.setName(user.getFullname());
            identityList.add(bpmIdentity);
            checkOpinion.setFiles(files);
            checkOpinion.setIsRead(0);
            checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
            checkOpinion.setQualfiedNames(user.getFullname());
            this.bpmCheckOpinionManager.update((Model)checkOpinion);
        }
        if (BeanUtils.isNotEmpty((Object)formData)) {
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)bpmTask.getProcInstId()));
            BusDataUtil.updateBoData(instance, bpmTask.getNodeId(), formData);
        }
        Map<String, Object> vars = this.getVars(bpmTask, opinion);
        MessageUtil.sendMsg("bpmHandTo", notifyType, userList, vars);
    }

    private Map<String, Object> getVars(BpmTask task, String opinion) {
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        IUser user = ContextUtil.getCurrentUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("delegate", user.getFullname());
        map.put("taskSubject", task.getSubject());
        map.put("baseUrl", baseUrl);
        map.put("taskId", task.getId());
        map.put("cause", opinion);
        map.put("nodeName", task.getName());
        map.put("instSubject", task.getSubject());
        return map;
    }

    @Override
    public void endProcessByTaskId(String taskId, String informType, String cause, String files) throws Exception {
        this.bpmTaskManager.endProcessByTaskId(taskId, informType, cause, files, JsonUtil.getMapper().createObjectNode());
    }
}

