/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.constant.TaskType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.persistence.manager.BpmCustomSignDataManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.BpmCustomSignData;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.util.BpmIdentityUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/runtime/customsign/v1/"})
@Api(tags={"BpmTaskSignLineController"})
public class BpmCustomSignDataController
extends BaseController<BpmCustomSignDataManager, BpmCustomSignData> {
    @Resource
    private BpmCustomSignDataManager bpmCustomSignDataManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    UCFeignService ucFeignService;

    @RequestMapping(value={"getParallelRevokeTasks"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5e76\u884c\u7b7e\u7f72\u8282\u70b9", httpMethod="GET", notes="\u83b7\u53d6\u5e76\u884c\u7b7e\u7f72\u8282\u70b9")
    public ArrayNode getSignLinesInstIdNodeId(@ApiParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam(required=true) String instanceId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam(required=true) String nodeId, @ApiParam(name="taskId", value="\u4efb\u52a1id", required=false) @RequestParam(required=false) String taskId) throws Exception {
        List parallelDatas = new ArrayList();
        ArrayNode listToArrayNode = null;
        List tasks = this.bpmTaskManager.getByInstId(instanceId);
        if (BeanUtils.isEmpty((Object)tasks)) {
            throw new BaseException("\u6ca1\u6709\u53ef\u64a4\u56de\u4efb\u52a1");
        }
        DefaultBpmTask currentTask = (DefaultBpmTask)tasks.get(0);
        String status = currentTask.getStatus();
        if (TaskType.SIGNLINEED.getKey().equals(status) && BeanUtils.isNotEmpty(parallelDatas = nodeId.equals(currentTask.getNodeId()) ? this.bpmCustomSignDataManager.getParallelAllSonByTaskId(taskId) : this.bpmCustomSignDataManager.getAllSignDataByBeforeSignTaskId(instanceId, taskId))) {
            ArrayList<String> userIds = new ArrayList<String>();
            for (BpmCustomSignData bpmCustomSignData : parallelDatas) {
                List qualfields2BpmIdentity = BpmIdentityUtil.qualfields2BpmIdentity((String)bpmCustomSignData.getExecutor());
                userIds.add(((BpmIdentity)qualfields2BpmIdentity.get(0)).getId());
            }
            listToArrayNode = JsonUtil.listToArrayNode(parallelDatas);
            listToArrayNode = this.ucFeignService.getUserInfoBySignData(listToArrayNode);
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instanceId));
            DefaultBpmDefinition def = this.bpmDefinitionManager.getById(instance.getProcDefId());
            String isReadRevoke = def.getIsReadRevoke();
            if ("true".equals(isReadRevoke)) {
                for (JsonNode jsonNode : listToArrayNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    objectNode.put("isRead", 0);
                }
            }
        }
        return listToArrayNode;
    }
}

