package com.artfess.portal.service;

import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.constants.CacheKeyConst;
import com.artfess.base.security.MethodAuthService;
import com.artfess.sysConfig.persistence.manager.SysRoleAuthManager;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 获取请求方法的授权信息
 *
 * @author liyg
 */
@Service
@Primary
public class SysMethodAuthService implements MethodAuthService {

    @Resource
    SysRoleAuthManager sysRoleAuthManager;

    @Cacheable(value = CacheKeyConst.EIP_SYS_METHOD_AUTH, key = CacheKeyConst.EIP_SYS_METHOD_AUTH_KEY, pureKey = true)
    @Override
    public List<HashMap<String, String>> getMethodAuth() {
        List<HashMap<String, String>> sysRoleAuthAll = sysRoleAuthManager.getSysRoleAuthAll();
        List<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        for (HashMap<String, String> map : sysRoleAuthAll) {
            result.add(map);
        }
        return result;
    }
}
