package com.artfess.query.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 个人浏览历史记录日志表（BIZ_QUERY_BROWSE_HISTORY）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@ApiModel(value="BizQueryBrowseHistory对象", description="个人浏览历史记录日志表（BIZ_QUERY_BROWSE_HISTORY）")
public class BizQueryBrowseHistory extends BaseModel<BizQueryBrowseHistory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "搜索分类【字典】（1个人 2企业）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "搜索标签ID【外键】（查企业、查老板、查风险）")
    @TableField("TAG_ID_")
    private String tagId;

    @ApiModelProperty(value = "搜索用户人员ID（外键）")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "搜索用户姓名")
    @TableField("USER_NAME_")
    private String userName;

    @ApiModelProperty(value = "搜索用户身份证号")
    @TableField("USER_CARD_")
    private String userCard;

    @ApiModelProperty(value = "电话号码")
    @TableField("USER_PHONE_")
    private String userPhone;

    @ApiModelProperty(value = "搜索内容")
    @TableField("SEARCH_CONTENT_")
    private String searchContent;

    @ApiModelProperty(value = "搜索时间")
    @TableField("SEARCH_TIME_")
    private LocalDateTime searchTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserCard() {
        return userCard;
    }

    public void setUserCard(String userCard) {
        this.userCard = userCard;
    }

    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    public String getSearchContent() {
        return searchContent;
    }

    public void setSearchContent(String searchContent) {
        this.searchContent = searchContent;
    }

    public LocalDateTime getSearchTime() {
        return searchTime;
    }

    public void setSearchTime(LocalDateTime searchTime) {
        this.searchTime = searchTime;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizQueryBrowseHistory{" +
            "id=" + id +
            ", type=" + type +
            ", tagId=" + tagId +
            ", userId=" + userId +
            ", userName=" + userName +
            ", userCard=" + userCard +
            ", userPhone=" + userPhone +
            ", searchContent=" + searchContent +
            ", searchTime=" + searchTime +
        "}";
    }
}
