/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormPrintTemplate;
import com.artfess.form.persistence.dao.FormPrintTemplateDao;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.persistence.manager.FormPrintTemplateManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formPrintTemplateManager")
public class FormPrintTemplateManagerImpl
extends BaseManagerImpl<FormPrintTemplateDao, FormPrintTemplate>
implements FormPrintTemplateManager {
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormMetaManager formMetaManager;

    @Override
    public void saveFormPrintTemplate(FormPrintTemplate formPrintTemplate) {
        QueryWrapper q = new QueryWrapper();
        q.eq((Object)"FORM_KEY_", (Object)formPrintTemplate.getFormKey());
        q.eq((Object)"PRINT_TYPE_", (Object)formPrintTemplate.getPrintType());
        List<FormPrintTemplate> list = ((FormPrintTemplateDao)this.baseMapper).getList((Wrapper<FormPrintTemplate>)q);
        if (list.size() > 0) {
            formPrintTemplate.setIsMain("N");
        } else if (!"".equals(formPrintTemplate.getIsMain())) {
            formPrintTemplate.setIsMain("Y");
        }
        super.create((Model)formPrintTemplate);
    }

    @Override
    @Transactional
    public void setDefaultVersion(String formKey, String id, String printType) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"FORM_KEY_", (Object)formKey);
        List formPrintTemplate = ((FormPrintTemplateDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        List formPrintTemplateY = formPrintTemplate.stream().filter(v -> id.equals(v.getId())).collect(Collectors.toList());
        ((FormPrintTemplate)((Object)formPrintTemplateY.get(0))).setIsMain("Y");
        List<FormPrintTemplate> formPrintTemplateN = formPrintTemplate.stream().filter(v -> !id.equals(v.getId())).collect(Collectors.toList());
        formPrintTemplateN.forEach(v -> v.setIsMain("N"));
        ((FormPrintTemplateDao)this.baseMapper).updateById(formPrintTemplateY.get(0));
        formPrintTemplateN.forEach(v -> ((FormPrintTemplateDao)this.baseMapper).updateById(v));
    }

    @Override
    public FormPrintTemplate getMainFormPrintTemplate(String formKey) {
        FormPrintTemplate formPrintTemplate = (FormPrintTemplate)((Object)((FormPrintTemplateDao)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormPrintTemplate::getFormKey, (Object)formKey)).eq(FormPrintTemplate::getIsMain, (Object)"Y")).eq(FormPrintTemplate::getPrintType, (Object)"word")));
        return formPrintTemplate;
    }

    @Override
    public List<FormPrintTemplate> getPrintTemplates(String formKey, String printType) {
        List<FormPrintTemplate> list = ((FormPrintTemplateDao)this.baseMapper).getList((Wrapper<FormPrintTemplate>)((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormPrintTemplate::getFormKey, (Object)formKey)).eq(FormPrintTemplate::getPrintType, (Object)printType)));
        return list;
    }

    @CacheEvict(value={"bpm:form:bpmForm"}, key="#formKey")
    protected void removeFromCache(String formKey) {
    }

    @Override
    public void removeByIds(String ... ids) {
        FormPrintTemplateManagerImpl bean = (FormPrintTemplateManagerImpl)AppUtil.getBean(this.getClass());
        for (String id : ids) {
            Form bpmForm;
            String formId;
            FormPrintTemplate formPrintTemplate = (FormPrintTemplate)this.get((Serializable)((Object)id));
            if ("form".equals(formPrintTemplate.getPrintType()) && StringUtil.isNotEmpty((String)(formId = formPrintTemplate.getFormId())) && BeanUtils.isNotEmpty((Object)((Object)(bpmForm = (Form)this.bpmFormManager.get((Serializable)((Object)formId)))))) {
                String formKey = bpmForm.getFormKey();
                this.bpmFormManager.remove((Serializable)((Object)bpmForm.getId()));
                String fromDefId = bpmForm.getDefId();
                this.formMetaManager.remove((Serializable)((Object)fromDefId));
                this.formMetaManager.deleteBpmFormBo(fromDefId);
                bean.removeFromCache(formKey);
            }
            this.remove((Serializable)((Object)id));
        }
    }

    @Override
    public IPage<FormPrintTemplate> getPrintList(QueryFilter<FormPrintTemplate> queryFilter) {
        String dbType = SQLUtil.getDbType();
        IPage<FormPrintTemplate> printList = null;
        printList = dbType.equals("postgresql") ? ((FormPrintTemplateDao)this.baseMapper).getPrintListPGSQL((IPage<FormPrintTemplate>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<FormPrintTemplate>)this.convert2Wrapper(queryFilter, this.currentModelClass())) : (dbType.equals("oracle") || dbType.equals("dm") ? ((FormPrintTemplateDao)this.baseMapper).getPrintListOracle((IPage<FormPrintTemplate>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<FormPrintTemplate>)this.convert2Wrapper(queryFilter, this.currentModelClass())) : ((FormPrintTemplateDao)this.baseMapper).getPrintList((IPage<FormPrintTemplate>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<FormPrintTemplate>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
        return printList;
    }

    @Override
    public FormPrintTemplate getMailPrintTemplates(String formKey, String printType) {
        FormPrintTemplate formPrintTemplate = (FormPrintTemplate)((Object)((FormPrintTemplateDao)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormPrintTemplate::getIsMain, (Object)"Y")).eq(FormPrintTemplate::getFormKey, (Object)formKey)).eq(FormPrintTemplate::getPrintType, (Object)printType)));
        return formPrintTemplate;
    }
}

