package com.artfess.query.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 我的关注记录表（BIZ_QUERY_MY_FOLLOW）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@ApiModel(value="BizQueryMyFollow对象", description="我的关注记录表（BIZ_QUERY_MY_FOLLOW）")
public class BizQueryMyFollow extends BaseModel<BizQueryMyFollow> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "关注分类【字典】（1个人 2企业）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "查询标签ID")
    @TableField("TAG_ID_")
    private String tagId;

    @ApiModelProperty(value = "用户人员ID（外键）")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "用户姓名")
    @TableField("USER_NAME_")
    private String userName;

    @ApiModelProperty(value = "关注名称")
    @TableField("SEARCH_CONTENT_")
    private String searchContent;

    @ApiModelProperty(value = "关注对象的关键字段名称")
    @TableField("SEARCH_FIELD_")
    private String searchField;

    @ApiModelProperty(value = "关注对象的关键字段值")
    @TableField("SEARCH_FIELD_VALUE_")
    private String searchFieldValue;


    @ApiModelProperty(value = "关注时间")
    @TableField("SEARCH_TIME_")
    private LocalDateTime searchTime;

    @ApiModelProperty(value = "搜索标签CODE")
    @TableField(exist = false)
    private String tagCode;

    @ApiModelProperty(value = "搜索标签【字典】（查企业、查老板、查风险）")
    @TableField(exist = false)
    private String tagName;

    @ApiModelProperty(value = "数据库表ID")
    @TableField(exist = false)
    private String tableId;

    @ApiModelProperty(value = "数据源编码")
    @TableField(exist = false)
    private String datasourcesAlias;

    @ApiModelProperty(value = "数据库表名称")
    @TableField(exist = false)
    private String tableCode;

    @ApiModelProperty(value = "数据库表描述")
    @TableField(exist = false)
    private String tableDesc;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getSearchContent() {
        return searchContent;
    }

    public void setSearchContent(String searchContent) {
        this.searchContent = searchContent;
    }

    public String getSearchField() {
        return searchField;
    }

    public void setSearchField(String searchField) {
        this.searchField = searchField;
    }

    public String getSearchFieldValue() {
        return searchFieldValue;
    }

    public void setSearchFieldValue(String searchFieldValue) {
        this.searchFieldValue = searchFieldValue;
    }

    public LocalDateTime getSearchTime() {
        return searchTime;
    }

    public void setSearchTime(LocalDateTime searchTime) {
        this.searchTime = searchTime;
    }

    public String getTagCode() {
        return tagCode;
    }

    public void setTagCode(String tagCode) {
        this.tagCode = tagCode;
    }

    public String getTagName() {
        return tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getDatasourcesAlias() {
        return datasourcesAlias;
    }

    public void setDatasourcesAlias(String datasourcesAlias) {
        this.datasourcesAlias = datasourcesAlias;
    }

    public String getTableCode() {
        return tableCode;
    }

    public void setTableCode(String tableCode) {
        this.tableCode = tableCode;
    }

    public String getTableDesc() {
        return tableDesc;
    }

    public void setTableDesc(String tableDesc) {
        this.tableDesc = tableDesc;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizQueryMyFollow{" +
            "id=" + id +
            ", type=" + type +
            ", tagId=" + tagId +
            ", userId=" + userId +
            ", userName=" + userName +
            ", searchContent=" + searchContent +
            ", searchTime=" + searchTime +
        "}";
    }
}
