/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.ext.listener;

import com.artfess.activiti.ext.listener.AbstractTaskListener;
import com.artfess.base.calendar.ICalendarService;
import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.BaseActionCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.constant.ExtractType;
import com.artfess.bpm.api.constant.MultiInstanceType;
import com.artfess.bpm.api.constant.NodeStatus;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.ScriptType;
import com.artfess.bpm.api.constant.TaskType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.NodeProperties;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.CustomSignNodeDef;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmCustomSignDataManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmSignDataManager;
import com.artfess.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.BpmSignData;
import com.artfess.bpm.persistence.model.BpmTaskDueTime;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.util.BpmUtil;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.delegate.DelegateTask;
import org.apache.commons.lang.exception.ExceptionUtils;

public class TaskSignCreateListener
extends AbstractTaskListener {
    private static final long serialVersionUID = 5830546066306214153L;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    ICalendarService iCalendarService;
    @Resource
    BpmTaskDueTimeManager bpmTaskDueTimeManager;
    @Resource
    BpmIdentityExtractService extractService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmCustomSignDataManager bpmCustomSignDataManager;

    @Override
    public EventType getBeforeTriggerEventType() {
        return EventType.TASK_SIGN_CREATE_EVENT;
    }

    @Override
    public EventType getAfterTriggerEventType() {
        return EventType.TASK_SIGN_POST_CREATE_EVENT;
    }

    @Override
    public void beforePluginExecute(BpmDelegateTask delegateTask) {
    }

    @Override
    public void triggerExecute(BpmDelegateTask delegateTask) {
        block32: {
            try {
                String executeId;
                DelegateTask actTask = (DelegateTask)delegateTask.getProxyObj();
                BpmTask task = BpmUtil.convertTask((BpmDelegateTask)delegateTask);
                ActionCmd cmd = ContextThreadUtil.getActionCmd();
                if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
                    ThreadMsgUtil.addMapMsg((String)"bpmTask_", (String)delegateTask.getId());
                }
                task.setExecId(actTask.getExecution().getParentId());
                if (MultiInstanceType.PARALLEL.equals((Object)delegateTask.multiInstanceType())) {
                    task.setExecId(delegateTask.getParentExecuteId(2));
                }
                String instId = task.getProcInstId();
                String nodeId = task.getNodeId();
                BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(task.getProcDefId(), nodeId);
                boolean isCommonSign = true;
                String signType = null;
                if (bpmNodeDef instanceof CustomSignNodeDef) {
                    CustomSignNodeDef customSignNodeDef = (CustomSignNodeDef)bpmNodeDef;
                    signType = customSignNodeDef.getSignType();
                    if (StringUtil.isNotEmpty((String)signType)) {
                        isCommonSign = false;
                    }
                    if ("Parallel".equals(signType)) {
                        task.setStatus(TaskType.SIGNLINEED.getKey());
                    }
                    if ("Sequential".equals(signType)) {
                        task.setStatus(TaskType.SIGNSEQUENCEED.getKey());
                    }
                    if ("ParallelApprove".equals(signType)) {
                        task.setStatus(TaskType.APPROVELINEED.getKey());
                    }
                }
                this.bpmTaskManager.create((Model)((DefaultBpmTask)task));
                BpmIdentity taskExecutor = (BpmIdentity)delegateTask.getVariable("assignee");
                ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
                identityList.add(taskExecutor);
                if (taskExecutor != null && ExtractType.EXACT_EXACT_DELAY.equals((Object)taskExecutor.getExtractType())) {
                    identityList = this.extractService.extractBpmIdentity(identityList);
                }
                try {
                    this.bpmTaskManager.assignUser(delegateTask, identityList);
                }
                catch (Exception e2) {
                    throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e2));
                }
                this.updatePreOpinion(isCommonSign);
                this.addOpinion(delegateTask, identityList, instId, signType, isCommonSign);
                try {
                    this.setDueTime(delegateTask, identityList);
                }
                catch (Exception e2) {
                    throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e2));
                }
                this.bpmProStatusManager.createOrUpd(instId, delegateTask.getBpmnDefId(), delegateTask.getTaskDefinitionKey(), delegateTask.getName(), NodeStatus.PENDING);
                Integer loopCounter = (Integer)delegateTask.getVariable("loopCounter");
                Integer token_ = 0;
                if (loopCounter == null) {
                    loopCounter = 0;
                }
                if (!(loopCounter != 0 || OpinionStatus.REJECT.getKey().equals(cmd.getActionName()) && "direct".equals(cmd.getTransitVars("backHandMode")))) {
                    BpmProcessInstance instance = (BpmProcessInstance)cmd.getTransitVars("processInstance");
                    if (BeanUtils.isEmpty((Object)instance)) {
                        instance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
                    }
                    if (BeanUtils.isNotEmpty((Object)instance)) {
                        BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
                        instanceManager.delVarByInstIdAndName(instance.getBpmnInstId(), new String[]{"bpm_node_users_" + nodeId, "bpm_destination_" + nodeId});
                    }
                }
                token_ = loopCounter;
                String resultVarName = "signResult_" + delegateTask.getTaskDefinitionKey();
                MultiInstanceType instanceType = delegateTask.multiInstanceType();
                if (MultiInstanceType.PARALLEL.equals((Object)instanceType)) {
                    delegateTask.removeVariable(resultVarName);
                    executeId = delegateTask.getParentExecuteId(2);
                    if (isCommonSign) {
                        this.addSignData(task, executeId, loopCounter);
                    } else if (cmd.getTransitVars("IsDoneUnused") == null) {
                        this.bpmCustomSignDataManager.addCustomSignData(task, null);
                    }
                } else {
                    delegateTask.setVariableLocal("token_", (Object)token_);
                    if (loopCounter == 0 || cmd.getTransitVars("IsDoneUnused") != null && ((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue()) {
                        delegateTask.removeVariable(resultVarName);
                        executeId = actTask.getExecution().getParentId();
                        if (isCommonSign) {
                            this.addSignData(task, executeId);
                        }
                    }
                    if (!isCommonSign && cmd.getTransitVars("IsDoneUnused") == null) {
                        String preTaskId = null;
                        if (cmd instanceof DefaultTaskFinishCmd && loopCounter > 0) {
                            DefaultTaskFinishCmd taskFinishCmd = (DefaultTaskFinishCmd)cmd;
                            preTaskId = taskFinishCmd.getTaskId();
                        }
                        this.bpmCustomSignDataManager.addCustomSignData(task, preTaskId);
                    }
                }
                cmd.addTransitVars("SubProcessMultiStartOrEndEvent", null);
                try {
                    this.bpmExeStackManager.pushStack(delegateTask);
                }
                catch (Exception e1) {
                    throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e1));
                }
                try {
                    BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
                    List users = bpmIdentityExtractService.extractUser(identityList);
                    if (BeanUtils.isNotEmpty((Object)users)) {
                        DefaultBpmTask defaultTask = BpmUtil.convertTask((DefaultBpmTask)((DefaultBpmTask)task), (String)task.getParentId(), (TaskType)TaskType.NORMAL, (IUser)((IUser)users.get(0)));
                        BpmUtil.restfulPluginExecut((DefaultBpmTask)defaultTask, (EventType)EventType.TASK_CREATE_EVENT);
                        break block32;
                    }
                    BpmUtil.restfulPluginExecut((DefaultBpmTask)((DefaultBpmTask)task), (EventType)EventType.TASK_CREATE_EVENT);
                }
                catch (Exception e) {
                    System.out.println("\u4f1a\u7b7erestful\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            catch (Exception e3) {
                throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e3));
            }
        }
    }

    @Override
    public void afterPluginExecute(BpmDelegateTask delegateTask) {
    }

    @Override
    protected ScriptType getScriptType() {
        return ScriptType.CREATE;
    }

    private void updatePreOpinion(boolean isCommonSign) {
        String id;
        DefaultBpmCheckOpinion defaultBpmCheckOpinion;
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        Map variables = cmd.getVariables();
        if (variables.containsKey("pre_bpm_check_opinion_id") && BeanUtils.isNotEmpty(variables.get("pre_bpm_check_opinion_id")) && BeanUtils.isNotEmpty((Object)(defaultBpmCheckOpinion = (DefaultBpmCheckOpinion)this.bpmCheckOpinionManager.get((Serializable)((Object)(id = String.valueOf(variables.get("pre_bpm_check_opinion_id"))))))) && StringUtil.isEmpty((String)defaultBpmCheckOpinion.getSignType()) && !isCommonSign) {
            defaultBpmCheckOpinion.setSignType("BeforeSign");
            this.bpmCheckOpinionManager.update((Model)defaultBpmCheckOpinion);
        }
    }

    private void addOpinion(BpmDelegateTask delegateTask, List<BpmIdentity> identityList, String instId, String signType, boolean isCommonSign) {
        String id;
        DefaultBpmCheckOpinion defaultBpmCheckOpinion;
        Map variables;
        DefaultBpmCheckOpinion opinion = BpmCheckOpinionUtil.buildBpmCheckOpinion((BpmDelegateTask)delegateTask, (String)instId);
        opinion.setSignType(signType);
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (isCommonSign && (variables = cmd.getVariables()).containsKey("pre_bpm_check_opinion_id") && BeanUtils.isNotEmpty(variables.get("pre_bpm_check_opinion_id")) && BeanUtils.isNotEmpty((Object)(defaultBpmCheckOpinion = (DefaultBpmCheckOpinion)this.bpmCheckOpinionManager.get((Serializable)((Object)(id = String.valueOf(variables.get("pre_bpm_check_opinion_id"))))))) && StringUtil.isNotEmpty((String)defaultBpmCheckOpinion.getSignType())) {
            opinion.setSignType("AfterSign");
        }
        if (cmd instanceof TaskFinishCmd) {
            opinion.setParentTaskId(((TaskFinishCmd)cmd).getTaskId());
        }
        String ids = BpmCheckOpinionUtil.getIdentityIds(identityList);
        String names = BpmCheckOpinionUtil.getIdentityNames(identityList);
        opinion.setQualfieds(ids);
        opinion.setQualfiedNames(names);
        this.bpmCheckOpinionManager.create((Model)opinion);
    }

    private void addSignData(BpmTask bpmTask, String executeId, Integer index) {
        String nodeId = bpmTask.getNodeId();
        BaseActionCmd actionCmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        List idList = (List)actionCmd.getBpmIdentities().get(nodeId);
        if (BeanUtils.isEmpty((Object)idList)) {
            return;
        }
        BpmIdentity bpmIdentity = (BpmIdentity)idList.get(index);
        BpmSignData signData = this.bpmSignDataManager.getSignData(bpmTask, executeId, bpmIdentity);
        signData.setIndex(Short.valueOf(index.shortValue()));
        this.bpmSignDataManager.create((Model)signData);
    }

    private void addSignData(BpmTask bpmTask, String executeId) {
        String nodeId = bpmTask.getNodeId();
        BaseActionCmd actionCmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        List idList = (List)actionCmd.getBpmIdentities().get(nodeId);
        if (BeanUtils.isEmpty((Object)idList)) {
            return;
        }
        for (short i = 0; i < idList.size(); i = (short)(i + 1)) {
            BpmIdentity bpmIdentity = (BpmIdentity)idList.get(i);
            BpmSignData signData = this.bpmSignDataManager.getSignData(bpmTask, executeId, bpmIdentity);
            signData.setIndex(Short.valueOf(i));
            this.bpmSignDataManager.create((Model)signData);
        }
    }

    private void setDueTime(BpmDelegateTask delegateTask, List<BpmIdentity> identityList) throws Exception {
        BpmIdentity bpmIdentity;
        DefaultBpmTask bpmTask = this.bpmTaskManager.getByRelateTaskId(delegateTask.getId());
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), bpmTask.getNodeId());
        BpmProcessDef bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(bpmTask.getProcDefId());
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
        NodeProperties nodeProperties = bpmNodeDef.getLocalProperties();
        LocalDateTime dueTime = null;
        String userId = "";
        String userName = "";
        int dueTimeMin = 0;
        String dateTpye = "";
        if (nodeProperties.getDueTime() != 0) {
            dueTimeMin = nodeProperties.getDueTime();
            dateTpye = nodeProperties.getDateType();
        } else {
            dueTimeMin = defExt.getExtProperties().getDueTime();
            dateTpye = defExt.getExtProperties().getDateType();
        }
        if (dueTimeMin == 0) {
            return;
        }
        if ("caltime".equals(dateTpye)) {
            dueTime = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)dueTimeMin, (long)TimeUtil.getTimeMillis((LocalDateTime)bpmTask.getCreateTime())));
        } else if (BeanUtils.isNotEmpty(identityList) && "user".equals((bpmIdentity = identityList.get(0)).getType())) {
            userId = bpmIdentity.getId();
            userName = bpmIdentity.getName();
            dueTime = this.iCalendarService.getEndTimeByUser(identityList.get(0).getId(), bpmTask.getCreateTime(), (long)dueTimeMin);
        }
        bpmTask.setDueTime(dueTime);
        this.bpmTaskManager.update((Model)bpmTask);
        BpmTaskDueTime bpmTaskDueTime = new BpmTaskDueTime();
        bpmTaskDueTime.setId(UniqueIdUtil.getSuid());
        bpmTaskDueTime.setDateType(dateTpye);
        bpmTaskDueTime.setDueTime(dueTimeMin);
        bpmTaskDueTime.setRemainingTime(dueTimeMin);
        bpmTaskDueTime.setExpirationDate(dueTime);
        bpmTaskDueTime.setInstId(bpmTask.getProcInstId());
        bpmTaskDueTime.setTaskId(bpmTask.getTaskId());
        bpmTaskDueTime.setStartTime(bpmTask.getCreateTime());
        bpmTaskDueTime.setUserId(userId);
        bpmTaskDueTime.setUserName(userName);
        bpmTaskDueTime.setIsNew(Short.valueOf((short)1));
        bpmTaskDueTime.setStatus(Short.valueOf((short)0));
        this.bpmTaskDueTimeManager.create((Model)bpmTaskDueTime);
    }
}

