/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.controller;

import com.artfess.activemq.model.JmsSysTypeChangeMessage;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.file.model.Catalog;
import com.artfess.file.persistence.manager.CatalogManager;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/file/catalog/v1"})
@Api(tags={"\u9644\u4ef6\u76ee\u5f55\u7ba1\u7406"})
@ApiGroup(group={"group_system"})
public class CatalogController
extends BaseController<CatalogManager, Catalog> {
    @Resource
    CatalogManager catalogManager;
    @Resource
    IUserService userService;
    @Resource
    JmsProducer jmsProducer;
    @Resource
    BaseContext baseContext;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u76ee\u5f55\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u76ee\u5f55\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<Catalog> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.catalogManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u76ee\u5f55\u8be6\u60c5", httpMethod="GET", notes="\u9644\u4ef6\u76ee\u5f55\u8be6\u60c5")
    public Catalog getJson(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        Catalog catalog = new Catalog();
        if (!StringUtil.isEmpty((String)id)) {
            catalog = (Catalog)this.catalogManager.get((Serializable)((Object)id));
        }
        return catalog;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u9644\u4ef6\u76ee\u5f55\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u76ee\u5f55\u4fe1\u606f")
    public CommonResult save(@ApiParam(name="catalog", value="\u9644\u4ef6\u76ee\u5f55\u5bf9\u8c61") @RequestBody Catalog catalog) throws Exception {
        String id = catalog.getId();
        try {
            String resultMsg;
            List<Catalog> catalogList = this.catalogManager.getListByParentId(catalog.getParentId(), catalog.getName());
            if (BeanUtils.isNotEmpty(catalogList)) {
                return new CommonResult(false, "\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            if (StringUtil.isEmpty((String)id)) {
                catalog.setId(UniqueIdUtil.getSuid());
                this.catalogManager.create((Model)catalog);
                resultMsg = "\u6dfb\u52a0\u9644\u4ef6\u76ee\u5f55\u6210\u529f";
            } else {
                Catalog oldType = (Catalog)this.catalogManager.get((Serializable)((Object)catalog.getId()));
                this.catalogManager.update((Model)catalog);
                this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage("FILE_TYPE", "", catalog.getName(), oldType.getName(), Integer.valueOf(1)));
                resultMsg = "\u66f4\u65b0\u9644\u4ef6\u76ee\u5f55\u6210\u529f";
            }
            return new CommonResult(resultMsg);
        }
        catch (Exception e) {
            String resultMsg = "\u5bf9\u9644\u4ef6\u76ee\u5f55\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, resultMsg);
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u76ee\u5f55\u5206\u7c7b", httpMethod="DELETE", notes="\u5220\u9664\u76ee\u5f55\u5206\u7c7b")
    public CommonResult remove(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        try {
            ArrayList<String> listId = new ArrayList<String>();
            List<String> childrenIds = this.catalogManager.getDepartmentList(id, listId);
            childrenIds.add(id);
            String[] ids = new String[childrenIds.size()];
            for (int i = 0; i < childrenIds.size(); ++i) {
                ids[i] = childrenIds.get(i);
            }
            QueryFilter filter = QueryFilter.build();
            filter.addFilter("ID", (Object)ids, QueryOP.IN);
            PageList query = this.catalogManager.query(filter);
            if (BeanUtils.isNotEmpty((Object)query) && BeanUtils.isNotEmpty((Object)query.getRows())) {
                for (Catalog type : query.getRows()) {
                    this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage("FILE_TYPE", "", type.getName(), type.getName(), Integer.valueOf(2)));
                }
            }
            this.catalogManager.removeByIds(Arrays.asList(ids));
            return new CommonResult("\u5220\u9664\u9644\u4ef6\u76ee\u5f55\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u9644\u4ef6\u76ee\u5f55\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getTree"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f97\u5230\u6811\u5f62\u9644\u4ef6\u5206\u7c7b\u76ee\u5f55\u6811", httpMethod="GET", notes="\u5f97\u5230\u6811\u5f62\u9644\u4ef6\u5206\u7c7b\u76ee\u5f55\u6811")
    public List<Catalog> getTree() throws Exception {
        IUser user = null;
        String accout = this.baseContext.getCurrentUserAccout();
        if (StringUtil.isNotEmpty((String)accout)) {
            user = this.userService.getUserByAccount(accout);
        }
        List<Object> listCatalog = new ArrayList();
        if (BeanUtils.isNotEmpty((Object)user) && user.isAdmin()) {
            listCatalog = this.catalogManager.list();
        } else if (BeanUtils.isNotEmpty((Object)user)) {
            listCatalog = this.catalogManager.getCatalogByCreateBy(user.getUserId());
        }
        Catalog cl = new Catalog();
        cl.setName("\u9644\u4ef6\u5206\u7c7b");
        cl.setId("-1");
        listCatalog.add((Object)cl);
        ArrayList<Catalog> listSysType = new ArrayList<Catalog>();
        for (Catalog catalog : listCatalog) {
            Catalog sysTypes = new Catalog();
            sysTypes = catalog;
            sysTypes.setOpen(true);
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.addFilter("parentId", (Object)catalog.getId(), QueryOP.EQUAL);
            List sys_Type = this.catalogManager.query(queryFilter).getRows();
            if (sys_Type != null && sys_Type.size() == 0) {
                sysTypes.setIsParent("true");
            }
            listSysType.add(catalog);
        }
        List rtnList = BeanUtils.listToTree(listSysType);
        return rtnList;
    }
}

