import req from '@/request.js';

const portal = window.context.portal;

const dataJob = window.context.dataJob;

const headersUrlencoded = {
  Accept: 'application/json',
  'Content-type': 'multipart/form-data',
};
export default {
  // 任务配置分页查询
  querySchedulerJob(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/scheduler/schedulerJob/v1/sliceQuery`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 新增任务配置
  addSchedulerJob(data) {
    const param = {
      url: `${portal}/biz/scheduler/schedulerJob/v1/insertSchedulerJob`,
      data,
      method: 'post',
      headers: headersUrlencoded,
    };
    return new Promise((resolve, reject) => {
      req
        .request(param)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 编辑任务配置
  editSchedulerJob(data) {
    const param = {
      url: `${portal}/biz/scheduler/schedulerJob/v1/updateSchedulerJob`,
      data,
      method: 'post',
      headers: headersUrlencoded,
    };
    return new Promise((resolve, reject) => {
      req
        .request(param)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 编辑任务配置
  getSchedulerJob(data) {
    const param = {
      url: `${portal}/biz/scheduler/schedulerJob/v1/getSchedulerJobById`,
      data,
      method: 'post',
      headers: headersUrlencoded,
    };
    return new Promise((resolve, reject) => {
      req
        .request(param)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 删除任务配置
  deleteSchedulerJob(id) {
    return new Promise((resolve, reject) => {
      req
        .remove(`${portal}/biz/scheduler/schedulerJob/v1/` + id)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 获取数据源列表
  getResourceList(type) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/datasourcesRelation/v1/queryList/${type}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 获取任务日志
  getlogList(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/scheduler/schedulerJobLog/v1/query`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 获取任务日志详情
  getlogDetail(id) {
    return new Promise((resolve, reject) => {
      req
        .get(`${portal}/biz/scheduler/schedulerJobLog/v1/` + id)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 任务执行一次
  executeOnce(data) {
    const param = {
      url: `${dataJob}/biz/scheduler/schedulerJob/v1/executeJob`,
      data,
      method: 'post',
      headers: headersUrlencoded,
    };
    return new Promise((resolve, reject) => {
      req
        .request(param)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 任务启动
  executeStart(data) {
    const param = {
      url: `${dataJob}/biz/scheduler/schedulerJob/v1/startUpJob`,
      data,
      method: 'post',
      headers: headersUrlencoded,
    };
    return new Promise((resolve, reject) => {
      req
        .request(param)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 任务停止
  executeStop(data) {
    const param = {
      url: `${dataJob}/biz/scheduler/schedulerJob/v1/stopJob`,
      data,
      method: 'post',
      headers: headersUrlencoded,
    };
    return new Promise((resolve, reject) => {
      req
        .request(param)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 验证类
  validClass(data) {
    return new Promise((resolve, reject) => {
      req
        .get(`${dataJob}/biz/scheduler/schedulerJob/v1/validClass?className=` + data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
};
