import req from '@/request.js'

const bpmModel = window.context.bpmModel
const portal = window.context.portal
const headersUrlencoded = {
  Accept: 'application/json;charset=utf-8',
  'Content-type': 'multipart/form-data'
}
export default {

  downLoadFile(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataResource/odsTable/v1/downloadMainTempFile/${tableId}`, null, 'blob').then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 移动表
  MoveData(queryParams, formData) {
    return new Promise((resolve, reject) => {
      // 拼接完整URL（查询参数）
      const url = `${portal}/biz/dataResource/odsTable/v1/updateCatalog?${queryParams}`

      req.put(url, formData, {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }).then(
        response => {
          if (response?.data?.state) {
            resolve(response.data)
          } else {
            reject(response?.data?.message || '操作失败')
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 获取ods资源目录下拉树
  queryTreeData(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataResource/odsCatalogs/v1/getTree`, {}).then(
        response => {
          if (response?.data.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 新增贴源层目录
  addTreeNode(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsCatalogs/v1/`, data).then(
        response => {
          if (response?.data.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 编辑贴源层目录
  editTreeNode(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataResource/odsCatalogs/v1/`, data).then(
        response => {
          console.log(response?.data.state)
          if (response?.data.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 删除贴源层目录
  delTreeNode(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/dataResource/odsCatalogs/v1/${id}`).then(
        response => {
          console.log(response?.data.state)
          if (response?.data.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 查询汇聚方资源项列表数据（已发布）
  getCompanySourceList(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataCollect/clusterTable/v1/list`, data).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 根据ODS目录 查询资源项
  getSourceList(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/query`, data).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  addByCompanySource(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/saveTable`, data).then(
        response => {
          console.log(response?.data.state)
          if (response?.data.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 批量导入接口
  bulkIImport(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/saveTableBatch`, data).then(
        response => {
          console.log(response?.data.state)
          if (response?.data.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  addSource(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/`, data).then(
        response => {
          console.log(response?.data.state)
          if (response?.data.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  updateSource(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataResource/odsTable/v1/`, data).then(
        response => {
          console.log(response?.data.state)
          if (response?.data.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  delSource(id) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/removeTable?tableId=${id}`).then(
        response => {
          console.log(response?.data.state)
          if (response?.data.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 发布
  publishSource(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/deploy/${tableId}`).then(
        response => {
          console.log(response?.data.state)
          if (response?.data.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 保存字段
  saveFields(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/odsField/v1/saveOrUpdates`, data)
        .then(res => resolve(res.data || {}))
        .catch(err => reject(err))
    })
  },
  // 发布后批量保存
  saveOrUpdateFields(data) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataResource/odsField/v1/saveOrUpdateFields`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 查询资源项数据
  getFieldsList(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/queryTableVo/${tableId}`).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 查询资源项数据
  getTableData(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/queryTableData`, data).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 新增验证
  checkSurfaceName(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/checkTableExists?tableNameEn=${data.tableNameEn}&type=${data.type}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 验证
  checkSurfaceCh(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/checkPhysicsTableExists?tableNameEn=${data.tableNameEn}&type=${data.type}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 建表语句
  gainTableSql(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataResource/odsTable/v1/queryTableSql/${tableId}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 未有表发布
  unpublishedTable(data) {
    const param = {
      url: `${bpmModel}/biz/dataResource/odsTable/v1/deployDotHaveTable`,
      data,
      method: 'post',
      headers: headersUrlencoded
    }
    return new Promise((resolve, reject) => {
      req.request(param).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // unpublishedTable(data) {
  //   return new Promise((resolve, reject) => {
  //     req.post(`${bpmModel}/biz/dataResource/odsTable/v1/deployDotHaveTable?tableId=${data.tableId}&tableSql=${data.tableSql}`, data).then(
  //       response => {
  //         if (response.data?.state) {
  //           resolve(response.data);
  //         } else {
  //           reject(response);
  //         }
  //       },
  //       error => {
  //         reject(error);
  //       },
  //     );
  //   });
  // },
  // 已有表发布
  existingTablePublishing(data) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataResource/odsTable/v1/deployHaveTable?tableId=${data.tableId}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  }
}
