import req from '@/request.js';

const bpmModel = window.context.bpmModel;
const bpmRunTime = window.context.bpmRunTime;
const portal = window.context.portal;

export default {
  // 每日数据日志
  getHistroyByDay(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataCollect/clusterDataCount/v1/query`, data).then(
        (response) => {
          resolve(response.data);
        },
        (error) => {
          reject(error);
        },
      );
    });
  },
  // 明细列表
  getHistroyByTime(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/clusterTemp/dataLog/v1/query`, data).then(
        (response) => {
          resolve(response.data);
        },
        (error) => {
          reject(error);
        },
      );
    });
  },

  // 明细数据
  getTableData(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataCollect/clusterTable/v1/queryTableData`, data).then(
        (response) => {
          resolve(response.data);
        },
        (error) => {
          reject(error);
        },
      );
    });
  },
};
